/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.support;

import java.io.IOException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;
import org.springframework.xml.sax.AbstractXmlReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MarshallingSource
extends SAXSource {
    private final Marshaller marshaller;
    private final Object content;

    public MarshallingSource(Marshaller marshaller, Object content) {
        Assert.notNull((Object)marshaller, (String)"'marshaller' must not be null");
        Assert.notNull((Object)content, (String)"'content' must not be null");
        this.marshaller = marshaller;
        this.content = content;
        this.setXMLReader(new MarshallingXmlReader());
        this.setInputSource(new InputSource());
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Object getContent() {
        return this.content;
    }

    private class MarshallingXmlReader
    extends AbstractXmlReader {
        private MarshallingXmlReader() {
        }

        public void parse(InputSource input) throws IOException, SAXException {
            this.parse();
        }

        public void parse(String systemId) throws IOException, SAXException {
            this.parse();
        }

        private void parse() throws SAXException {
            SAXResult result = new SAXResult(this.getContentHandler());
            result.setLexicalHandler(this.getLexicalHandler());
            try {
                MarshallingSource.this.marshaller.marshal(MarshallingSource.this.content, result);
            }
            catch (IOException ex) {
                SAXParseException saxException = new SAXParseException(ex.getMessage(), null, null, -1, -1, ex);
                if (this.getErrorHandler() != null) {
                    this.getErrorHandler().fatalError(saxException);
                }
                throw saxException;
            }
        }
    }
}

