/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support.matcher.xmlunit2;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.matcher.xmlunit2.DiffMatcher;
import org.springframework.xml.transform.TransformerHelper;
import org.w3c.dom.Document;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class PayloadDiffMatcher
extends DiffMatcher {
    private final Source expected;
    private final TransformerHelper transformerHelper = new TransformerHelper();

    public PayloadDiffMatcher(Source expected) {
        Assert.notNull((Object)expected, (String)"'expected' must not be null");
        this.expected = expected;
    }

    @Override
    protected final Diff createDiff(WebServiceMessage message) {
        Source payload = message.getPayloadSource();
        if (payload == null) {
            AssertionErrors.fail("Request message does not contain payload");
        }
        return this.createDiff(payload);
    }

    protected Diff createDiff(Source payload) {
        Document expectedDocument = this.createDocumentFromSource(this.expected);
        Document actualDocument = this.createDocumentFromSource(payload);
        return DiffBuilder.compare((Object)expectedDocument).withTest((Object)actualDocument).checkForSimilar().build();
    }

    private Document createDocumentFromSource(Source source) {
        try {
            DOMResult result = new DOMResult();
            this.transformerHelper.transform(source, (Result)result);
            return (Document)result.getNode();
        }
        catch (TransformerException ex) {
            AssertionErrors.fail("Could not transform source to DOMResult" + ex.getMessage());
            return null;
        }
    }
}

