/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support.creator;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.creator.AbstractMessageCreator;
import org.springframework.xml.transform.TransformerHelper;

public class PayloadMessageCreator
extends AbstractMessageCreator {
    private final Source payload;
    private TransformerHelper transformerHelper = new TransformerHelper();

    public PayloadMessageCreator(Source payload) {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        this.payload = payload;
    }

    @Override
    protected void doWithMessage(WebServiceMessage message) throws IOException {
        try {
            this.transformerHelper.transform(this.payload, message.getPayloadResult());
        }
        catch (TransformerException ex) {
            AssertionErrors.fail("Could not transform request payload to message: " + ex.getMessage());
        }
    }
}

