/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Service;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.URLName;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.search.HeaderTerm;
import jakarta.mail.search.SearchTerm;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.mail.MailTransportException;
import org.springframework.ws.transport.mail.support.MailTransportUtils;

public class MailSenderConnection
extends AbstractSenderConnection {
    private static final Log logger = LogFactory.getLog(MailSenderConnection.class);
    private final Session session;
    private @Nullable MimeMessage requestMessage;
    private @Nullable Message responseMessage;
    private @Nullable String requestContentType;
    private boolean deleteAfterReceive = false;
    private final URLName storeUri;
    private final URLName transportUri;
    private @Nullable ByteArrayOutputStream requestBuffer;
    private @Nullable InternetAddress from;
    private final InternetAddress to;
    private @Nullable String subject;
    private final long receiveTimeout;
    private @Nullable Store store;
    private @Nullable Folder folder;

    protected MailSenderConnection(Session session, URLName transportUri, URLName storeUri, InternetAddress to, long receiveTimeout) {
        Assert.notNull((Object)session, (String)"'session' must not be null");
        Assert.notNull((Object)transportUri, (String)"'transportUri' must not be null");
        Assert.notNull((Object)storeUri, (String)"'storeUri' must not be null");
        Assert.notNull((Object)to, (String)"'to' must not be null");
        this.session = session;
        this.transportUri = transportUri;
        this.storeUri = storeUri;
        this.to = to;
        this.receiveTimeout = receiveTimeout;
    }

    public MimeMessage getRequestMessage() {
        Assert.notNull((Object)this.requestMessage, (String)"RequestMessage is not available");
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        Assert.notNull((Object)this.responseMessage, (String)"ResponseMessage is not available");
        return this.responseMessage;
    }

    void setFrom(InternetAddress from) {
        this.from = from;
    }

    void setSubject(String subject) {
        this.subject = subject;
    }

    public URI getUri() throws URISyntaxException {
        return MailTransportUtils.toUri(this.to, this.subject);
    }

    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        try {
            this.requestMessage = new MimeMessage(this.session);
            this.requestMessage.setRecipient(Message.RecipientType.TO, (Address)this.to);
            this.requestMessage.setSentDate(new Date());
            if (this.from != null) {
                this.requestMessage.setFrom((Address)this.from);
            }
            if (this.subject != null) {
                this.requestMessage.setSubject(this.subject);
            }
            this.requestBuffer = new ByteArrayOutputStream();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    public void addRequestHeader(String name, String value) throws IOException {
        try {
            this.getRequestMessage().addHeader(name, value);
            if ("Content-Type".equals(name)) {
                this.requestContentType = value;
            }
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    protected OutputStream getRequestOutputStream() throws IOException {
        Assert.notNull((Object)this.requestBuffer, (String)"Request OutputStream is not available");
        return this.requestBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        Assert.state((this.requestMessage != null ? 1 : 0) != 0, (String)"onSendBeforeWrite has not been called");
        Assert.state((this.requestBuffer != null ? 1 : 0) != 0, (String)"onSendBeforeWrite has not been called");
        Transport transport = null;
        try {
            this.requestMessage.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.requestBuffer.toByteArray(), this.requestContentType)));
            transport = this.session.getTransport(this.transportUri);
            transport.connect();
            this.requestMessage.saveChanges();
            transport.sendMessage((Message)this.requestMessage, this.requestMessage.getAllRecipients());
            if (transport == null) return;
        }
        catch (MessagingException ex) {
            try {
                throw new MailTransportException(ex);
            }
            catch (Throwable throwable) {
                if (transport == null) throw throwable;
                MailTransportUtils.closeService(transport);
                throw throwable;
            }
        }
        MailTransportUtils.closeService((Service)transport);
        return;
    }

    protected void onReceiveBeforeRead() throws IOException {
        Assert.state((this.requestMessage != null ? 1 : 0) != 0, (String)"onSendBeforeWrite has not been called");
        try {
            String requestMessageId = this.requestMessage.getMessageID();
            Assert.hasLength((String)requestMessageId, (String)("No Message-ID found on request message [" + String.valueOf(this.requestMessage) + "]"));
            try {
                Thread.sleep(this.receiveTimeout);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.folder = this.openFolder();
            HeaderTerm searchTerm = new HeaderTerm("In-Reply-To", requestMessageId);
            Message[] responses = this.folder.search((SearchTerm)searchTerm);
            if (responses.length > 0) {
                if (responses.length > 1) {
                    logger.warn((Object)("Received more than one response for request with ID [" + requestMessageId + "]"));
                }
                this.responseMessage = responses[0];
            }
            if (this.deleteAfterReceive && this.responseMessage != null) {
                this.responseMessage.setFlag(Flags.Flag.DELETED, true);
            }
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    private Folder openFolder() throws MessagingException {
        this.store = this.session.getStore(this.storeUri);
        this.store.connect();
        Folder folder = this.store.getFolder(this.storeUri);
        if (folder == null || !folder.exists()) {
            throw new IllegalStateException("No default folder to receive from");
        }
        if (this.deleteAfterReceive) {
            folder.open(2);
        } else {
            folder.open(1);
        }
        return folder;
    }

    protected boolean hasResponse() throws IOException {
        return this.responseMessage != null;
    }

    public Iterator<String> getResponseHeaderNames() throws IOException {
        try {
            ArrayList<String> headers = new ArrayList<String>();
            Enumeration enumeration = this.getResponseMessage().getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                headers.add(header.getName());
            }
            return headers.iterator();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    public Iterator<String> getResponseHeaders(String name) throws IOException {
        try {
            String[] headers = this.getResponseMessage().getHeader(name);
            return Arrays.asList(headers).iterator();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    protected InputStream getResponseInputStream() throws IOException {
        try {
            return this.getResponseMessage().getDataHandler().getInputStream();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public @Nullable String getErrorMessage() throws IOException {
        return null;
    }

    public void onClose() throws IOException {
        if (this.folder != null) {
            MailTransportUtils.closeFolder(this.folder, this.deleteAfterReceive);
        }
        if (this.store != null) {
            MailTransportUtils.closeService((Service)this.store);
        }
    }

    private static final class ByteArrayDataSource
    implements DataSource {
        private final String contentType;
        private final byte[] data;

        ByteArrayDataSource(byte[] data, @Nullable String contentType) {
            this.data = data;
            this.contentType = contentType != null ? contentType : "application/octet-stream";
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return "ByteArrayDataSource";
        }
    }
}

