/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.support.AbstractStandaloneMessageReceiver;
import org.springframework.ws.transport.xmpp.XmppReceiverConnection;

public class XmppMessageReceiver
extends AbstractStandaloneMessageReceiver {
    public static final String DEFAULT_MESSAGE_ENCODING = "UTF-8";
    private XMPPTCPConnection connection;
    private WebServicePacketListener packetListener;
    private final String messageEncoding = "UTF-8";

    public void setConnection(XMPPTCPConnection connection) {
        this.connection = connection;
    }

    protected void onActivate() throws XMPPException, IOException, SmackException {
        if (!this.connection.isConnected()) {
            try {
                this.connection.connect();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }

    protected void onStart() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting XMPP receiver [" + String.valueOf(this.connection.getUser()) + "]"));
        }
        this.packetListener = new WebServicePacketListener();
        StanzaTypeFilter packetFilter = new StanzaTypeFilter(Message.class);
        this.connection.addAsyncStanzaListener((StanzaListener)this.packetListener, (StanzaFilter)packetFilter);
    }

    protected void onStop() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping XMPP receiver [" + String.valueOf(this.connection.getUser()) + "]"));
        }
        this.connection.removeAsyncStanzaListener((StanzaListener)this.packetListener);
        this.packetListener = null;
    }

    protected void onShutdown() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Shutting down XMPP receiver [" + String.valueOf(this.connection.getUser()) + "]"));
        }
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }

    private final class WebServicePacketListener
    implements StanzaListener {
        private WebServicePacketListener() {
        }

        public void processStanza(Stanza packet) {
            XmppMessageReceiver.this.logger.info((Object)("Received " + String.valueOf(packet)));
            if (packet instanceof Message) {
                Message message = (Message)packet;
                try {
                    XmppReceiverConnection wsConnection = new XmppReceiverConnection((XMPPConnection)XmppMessageReceiver.this.connection, message);
                    wsConnection.setMessageEncoding(XmppMessageReceiver.this.messageEncoding);
                    XmppMessageReceiver.this.handleConnection((WebServiceConnection)wsConnection);
                }
                catch (Exception ex) {
                    XmppMessageReceiver.this.logger.error((Object)ex);
                }
            }
        }
    }
}

