/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp.support;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class XmppConnectionFactoryBean
implements FactoryBean<XMPPTCPConnection>,
InitializingBean,
DisposableBean {
    private static final int DEFAULT_PORT = 5222;
    private XMPPTCPConnection connection;
    private String host;
    private int port = 5222;
    private String serviceName;
    private String username;
    private String password;
    private String resource;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"'port' must be larger than 0");
        this.port = port;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws XMPPException, IOException, SmackException {
        XMPPTCPConnectionConfiguration configuration = this.createConnectionConfiguration(this.host, this.port, this.serviceName);
        Assert.notNull((Object)configuration, (String)"'configuration' must not be null");
        Assert.hasText((String)this.username, (String)"'username' must not be empty");
        Assert.hasText((String)this.password, (String)"'password' must not be empty");
        this.connection = new XMPPTCPConnection(configuration);
        try {
            this.connection.connect();
            if (StringUtils.hasText((String)this.resource)) {
                this.connection.login((CharSequence)this.username, this.password, Resourcepart.from((String)this.resource));
            } else {
                this.connection.login((CharSequence)this.username, this.password);
            }
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    public void destroy() {
        this.connection.disconnect();
    }

    public XMPPTCPConnection getObject() {
        return this.connection;
    }

    public Class<XMPPTCPConnection> getObjectType() {
        return XMPPTCPConnection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected XMPPTCPConnectionConfiguration createConnectionConfiguration(String host, int port, String serviceName) throws XmppStringprepException {
        Assert.hasText((String)host, (String)"'host' must not be empty");
        if (StringUtils.hasText((String)serviceName)) {
            return ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost((CharSequence)host)).setPort(port)).setXmppDomain(serviceName)).build();
        }
        return ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost((CharSequence)host)).setPort(port)).build();
    }
}

