/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractReceiverConnection;
import org.springframework.ws.transport.jms.BytesMessageInputStream;
import org.springframework.ws.transport.jms.BytesMessageOutputStream;
import org.springframework.ws.transport.jms.JmsTransportException;
import org.springframework.ws.transport.jms.TextMessageInputStream;
import org.springframework.ws.transport.jms.TextMessageOutputStream;
import org.springframework.ws.transport.jms.support.JmsTransportUtils;

public class JmsReceiverConnection
extends AbstractReceiverConnection {
    private final Message requestMessage;
    private final Session session;
    private Message responseMessage;
    private String textMessageEncoding;
    private MessagePostProcessor postProcessor;

    private JmsReceiverConnection(Message requestMessage, Session session) {
        Assert.notNull((Object)requestMessage, (String)"requestMessage must not be null");
        Assert.notNull((Object)session, (String)"session must not be null");
        this.requestMessage = requestMessage;
        this.session = session;
    }

    protected JmsReceiverConnection(BytesMessage requestMessage, Session session) {
        this((Message)requestMessage, session);
    }

    protected JmsReceiverConnection(TextMessage requestMessage, String encoding, Session session) {
        this((Message)requestMessage, session);
        this.textMessageEncoding = encoding;
    }

    void setPostProcessor(MessagePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public URI getUri() throws URISyntaxException {
        try {
            return JmsTransportUtils.toUri(this.requestMessage.getJMSDestination());
        }
        catch (JMSException ex) {
            throw new URISyntaxException("", ex.getMessage());
        }
    }

    public String getErrorMessage() throws IOException {
        return null;
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public Iterator<String> getRequestHeaderNames() throws IOException {
        try {
            return JmsTransportUtils.getHeaderNames(this.requestMessage);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property names", ex);
        }
    }

    public Iterator<String> getRequestHeaders(String name) throws IOException {
        try {
            return JmsTransportUtils.getHeaders(this.requestMessage, name);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property value", ex);
        }
    }

    protected InputStream getRequestInputStream() throws IOException {
        if (this.requestMessage instanceof BytesMessage) {
            return new BytesMessageInputStream((BytesMessage)this.requestMessage);
        }
        if (this.requestMessage instanceof TextMessage) {
            return new TextMessageInputStream((TextMessage)this.requestMessage, this.textMessageEncoding);
        }
        throw new IllegalStateException("Unknown request message type [" + this.requestMessage + "]");
    }

    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        try {
            if (this.requestMessage instanceof BytesMessage) {
                this.responseMessage = this.session.createBytesMessage();
            } else if (this.requestMessage instanceof TextMessage) {
                this.responseMessage = this.session.createTextMessage();
            } else {
                throw new IllegalStateException("Unknown request message type [" + this.requestMessage + "]");
            }
            String correlation = this.requestMessage.getJMSCorrelationID();
            if (correlation == null) {
                correlation = this.requestMessage.getJMSMessageID();
            }
            this.responseMessage.setJMSCorrelationID(correlation);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not create response message", ex);
        }
    }

    public void addResponseHeader(String name, String value) throws IOException {
        try {
            JmsTransportUtils.addHeader(this.responseMessage, name, value);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not set property", ex);
        }
    }

    protected OutputStream getResponseOutputStream() throws IOException {
        if (this.responseMessage instanceof BytesMessage) {
            return new BytesMessageOutputStream((BytesMessage)this.responseMessage);
        }
        if (this.responseMessage instanceof TextMessage) {
            return new TextMessageOutputStream((TextMessage)this.responseMessage, this.textMessageEncoding);
        }
        throw new IllegalStateException("Unknown response message type [" + this.responseMessage + "]");
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        MessageProducer messageProducer = null;
        try {
            if (this.requestMessage.getJMSReplyTo() != null) {
                messageProducer = this.session.createProducer(this.requestMessage.getJMSReplyTo());
                messageProducer.setDeliveryMode(this.requestMessage.getJMSDeliveryMode());
                messageProducer.setPriority(this.requestMessage.getJMSPriority());
                if (this.postProcessor != null) {
                    this.responseMessage = this.postProcessor.postProcessMessage(this.responseMessage);
                }
                messageProducer.send(this.responseMessage);
            }
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
        finally {
            JmsUtils.closeMessageProducer(messageProducer);
        }
    }
}

