/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import org.springframework.util.Assert;
import org.springframework.ws.transport.jms.JmsTransportException;

class BytesMessageInputStream
extends InputStream {
    private final BytesMessage message;

    BytesMessageInputStream(BytesMessage message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        this.message = message;
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            return this.message.readBytes(b);
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off == 0) {
            try {
                return this.message.readBytes(b, len);
            }
            catch (JMSException ex) {
                throw new JmsTransportException(ex);
            }
        }
        return super.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        try {
            return this.message.readByte();
        }
        catch (MessageEOFException ex) {
            return -1;
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
    }
}

