/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.jivesoftware.smack.XMPPConnection;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.xmpp.XmppSenderConnection;
import org.springframework.ws.transport.xmpp.support.XmppTransportUtils;

public class XmppMessageSender
implements WebServiceMessageSender,
InitializingBean {
    public static final long DEFAULT_RECEIVE_TIMEOUT = -1L;
    public static final String DEFAULT_MESSAGE_ENCODING = "UTF-8";
    private long receiveTimeout = -1L;
    private String messageEncoding = "UTF-8";
    private XMPPConnection connection;

    public void setConnection(XMPPConnection connection) {
        this.connection = connection;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setMessageEncoding(String messageEncoding) {
        this.messageEncoding = messageEncoding;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.connection, (String)"'connection' is required");
    }

    public WebServiceConnection createConnection(URI uri) throws IOException {
        String to = XmppTransportUtils.getTo(uri);
        String thread = this.createThread();
        XmppSenderConnection connection = new XmppSenderConnection(this.connection, to, thread);
        connection.setReceiveTimeout(this.receiveTimeout);
        connection.setMessageEncoding(this.messageEncoding);
        return connection;
    }

    public boolean supports(URI uri) {
        return uri.getScheme().equals("xmpp");
    }

    protected String createThread() {
        return UUID.randomUUID().toString();
    }
}

