/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;

public abstract class JmsTransportUtils {
    private static final String[] CONVERSION_TABLE = new String[]{"Content-Type", "SOAPJMS_contentType", "Content-Length", "SOAPJMS_contentLength", "SOAPAction", "SOAPJMS_soapAction", "Accept-Encoding", "SOAPJMS_acceptEncoding"};
    private static final Pattern DESTINATION_NAME_PATTERN = Pattern.compile("^([^\\?]+)");
    private static final Pattern DELIVERY_MODE_PATTERN = Pattern.compile("deliveryMode=(PERSISTENT|NON_PERSISTENT)");
    private static final Pattern MESSAGE_TYPE_PATTERN = Pattern.compile("messageType=(BYTES_MESSAGE|TEXT_MESSAGE)");
    private static final Pattern TIME_TO_LIVE_PATTERN = Pattern.compile("timeToLive=(\\d+)");
    private static final Pattern PRIORITY_PATTERN = Pattern.compile("priority=(\\d)");
    private static final Pattern REPLY_TO_NAME_PATTERN = Pattern.compile("replyToName=([^&]+)");

    private JmsTransportUtils() {
    }

    public static String headerToJmsProperty(String headerName) {
        for (int i = 0; i < CONVERSION_TABLE.length; i += 2) {
            if (!CONVERSION_TABLE[i].equals(headerName)) continue;
            return CONVERSION_TABLE[i + 1];
        }
        return headerName;
    }

    public static String jmsPropertyToHeader(String propertyName) {
        for (int i = 1; i < CONVERSION_TABLE.length; i += 2) {
            if (!CONVERSION_TABLE[i].equals(propertyName)) continue;
            return CONVERSION_TABLE[i - 1];
        }
        return propertyName;
    }

    public static URI toUri(Destination destination) throws URISyntaxException, JMSException {
        String destinationName;
        if (destination == null) {
            return null;
        }
        if (destination instanceof Queue) {
            destinationName = ((Queue)destination).getQueueName();
        } else if (destination instanceof Topic) {
            Topic topic = (Topic)destination;
            destinationName = topic.getTopicName();
        } else {
            throw new IllegalArgumentException("Destination [ " + destination + "] is neither Queue nor Topic");
        }
        return new URI("jms", destinationName, null);
    }

    public static String getDestinationName(URI uri) {
        return JmsTransportUtils.getStringParameter(DESTINATION_NAME_PATTERN, uri);
    }

    public static void addHeader(Message message, String name, String value) throws JMSException {
        String propertyName = JmsTransportUtils.headerToJmsProperty(name);
        message.setStringProperty(propertyName, value);
    }

    public static Iterator<String> getHeaderNames(Message message) throws JMSException {
        Enumeration properties = message.getPropertyNames();
        ArrayList<String> results = new ArrayList<String>();
        while (properties.hasMoreElements()) {
            String property = (String)properties.nextElement();
            if (!property.startsWith("SOAPJMS_")) continue;
            String header = JmsTransportUtils.jmsPropertyToHeader(property);
            results.add(header);
        }
        return results.iterator();
    }

    public static Iterator<String> getHeaders(Message message, String name) throws JMSException {
        String propertyName = JmsTransportUtils.headerToJmsProperty(name);
        String value = message.getStringProperty(propertyName);
        if (value != null) {
            return Collections.singletonList(value).iterator();
        }
        return Collections.emptyList().iterator();
    }

    public static int getDeliveryMode(URI uri) {
        String deliveryMode = JmsTransportUtils.getStringParameter(DELIVERY_MODE_PATTERN, uri);
        if ("NON_PERSISTENT".equals(deliveryMode)) {
            return 1;
        }
        if ("PERSISTENT".equals(deliveryMode)) {
            return 2;
        }
        return 2;
    }

    public static int getMessageType(URI uri) {
        String deliveryMode = JmsTransportUtils.getStringParameter(MESSAGE_TYPE_PATTERN, uri);
        if ("TEXT_MESSAGE".equals(deliveryMode)) {
            return 2;
        }
        return 1;
    }

    public static long getTimeToLive(URI uri) {
        return JmsTransportUtils.getLongParameter(TIME_TO_LIVE_PATTERN, uri, 0L);
    }

    public static int getPriority(URI uri) {
        return JmsTransportUtils.getIntParameter(PRIORITY_PATTERN, uri, 4);
    }

    public static String getReplyToName(URI uri) {
        return JmsTransportUtils.getStringParameter(REPLY_TO_NAME_PATTERN, uri);
    }

    private static String getStringParameter(Pattern pattern, URI uri) {
        Matcher matcher = pattern.matcher(uri.getSchemeSpecificPart());
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    private static int getIntParameter(Pattern pattern, URI uri, int defaultValue) {
        Matcher matcher = pattern.matcher(uri.getSchemeSpecificPart());
        if (matcher.find() && matcher.groupCount() == 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static long getLongParameter(Pattern pattern, URI uri, long defaultValue) {
        Matcher matcher = pattern.matcher(uri.getSchemeSpecificPart());
        if (matcher.find() && matcher.groupCount() == 1) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

