/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.jms.BytesMessageInputStream;
import org.springframework.ws.transport.jms.BytesMessageOutputStream;
import org.springframework.ws.transport.jms.JmsTransportException;
import org.springframework.ws.transport.jms.TextMessageInputStream;
import org.springframework.ws.transport.jms.TextMessageOutputStream;
import org.springframework.ws.transport.jms.support.JmsTransportUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsSenderConnection
extends AbstractSenderConnection {
    private final ConnectionFactory connectionFactory;
    private final Connection connection;
    private final Session session;
    private final Destination requestDestination;
    private Message requestMessage;
    private Destination responseDestination;
    private Message responseMessage;
    private long receiveTimeout;
    private int deliveryMode;
    private long timeToLive;
    private int priority;
    private String textMessageEncoding;
    private MessagePostProcessor postProcessor;
    private boolean sessionTransacted = false;

    protected JmsSenderConnection(ConnectionFactory connectionFactory, Connection connection, Session session, Destination requestDestination, Message requestMessage) throws JMSException {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        Assert.notNull((Object)connection, (String)"'connection' must not be null");
        Assert.notNull((Object)session, (String)"'session' must not be null");
        Assert.notNull((Object)requestDestination, (String)"'requestDestination' must not be null");
        Assert.notNull((Object)requestMessage, (String)"'requestMessage' must not be null");
        this.connectionFactory = connectionFactory;
        this.connection = connection;
        this.session = session;
        this.requestDestination = requestDestination;
        this.requestMessage = requestMessage;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    void setResponseDestination(Destination responseDestination) {
        this.responseDestination = responseDestination;
    }

    void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }

    void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    void setTextMessageEncoding(String textMessageEncoding) {
        this.textMessageEncoding = textMessageEncoding;
    }

    void setPostProcessor(MessagePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    public URI getUri() throws URISyntaxException {
        try {
            return JmsTransportUtils.toUri(this.requestDestination);
        }
        catch (JMSException ex) {
            throw new URISyntaxException("", ex.getMessage());
        }
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public String getErrorMessage() throws IOException {
        return null;
    }

    protected void addRequestHeader(String name, String value) throws IOException {
        try {
            JmsTransportUtils.addHeader(this.requestMessage, name, value);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not set property", ex);
        }
    }

    protected OutputStream getRequestOutputStream() throws IOException {
        if (this.requestMessage instanceof BytesMessage) {
            return new BytesMessageOutputStream((BytesMessage)this.requestMessage);
        }
        if (this.requestMessage instanceof TextMessage) {
            return new TextMessageOutputStream((TextMessage)this.requestMessage, this.textMessageEncoding);
        }
        throw new IllegalStateException("Unknown request message type [" + this.requestMessage + "]");
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        MessageProducer messageProducer = null;
        try {
            messageProducer = this.session.createProducer(this.requestDestination);
            messageProducer.setDeliveryMode(this.deliveryMode);
            messageProducer.setTimeToLive(this.timeToLive);
            messageProducer.setPriority(this.priority);
            if (this.responseDestination == null) {
                this.responseDestination = this.session.createTemporaryQueue();
            }
            this.requestMessage.setJMSReplyTo(this.responseDestination);
            if (this.postProcessor != null) {
                this.requestMessage = this.postProcessor.postProcessMessage(this.requestMessage);
            }
            this.connection.start();
            messageProducer.send(this.requestMessage);
            if (this.session.getTransacted() && this.isSessionLocallyTransacted(this.session)) {
                JmsUtils.commitIfNecessary((Session)this.session);
            }
        }
        catch (JMSException ex) {
            try {
                throw new JmsTransportException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeMessageProducer(messageProducer);
                throw throwable;
            }
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
    }

    private boolean isSessionLocallyTransacted(Session session) {
        return this.sessionTransacted && !ConnectionFactoryUtils.isSessionTransactional((Session)session, (ConnectionFactory)this.connectionFactory);
    }

    protected void onReceiveBeforeRead() throws IOException {
        MessageConsumer messageConsumer;
        block21: {
            messageConsumer = null;
            try {
                Message message;
                if (this.responseDestination instanceof TemporaryQueue || this.responseDestination instanceof TemporaryTopic) {
                    messageConsumer = this.session.createConsumer(this.responseDestination);
                } else {
                    String messageId = this.requestMessage.getJMSMessageID().replaceAll("'", "''");
                    String messageSelector = "JMSCorrelationID = '" + messageId + "'";
                    messageConsumer = this.session.createConsumer(this.responseDestination, messageSelector);
                }
                Message message2 = message = this.receiveTimeout >= 0L ? messageConsumer.receive(this.receiveTimeout) : messageConsumer.receive();
                if (message instanceof BytesMessage || message instanceof TextMessage) {
                    this.responseMessage = message;
                    break block21;
                }
                if (message == null) break block21;
                throw new IllegalArgumentException("Wrong message type: [" + message.getClass() + "]. " + "Only BytesMessages or TextMessages can be handled.");
            }
            catch (JMSException ex) {
                try {
                    throw new JmsTransportException(ex);
                }
                catch (Throwable throwable) {
                    JmsUtils.closeMessageConsumer(messageConsumer);
                    if (this.responseDestination instanceof TemporaryQueue) {
                        try {
                            ((TemporaryQueue)this.responseDestination).delete();
                        }
                        catch (JMSException e) {}
                    } else if (this.responseDestination instanceof TemporaryTopic) {
                        try {
                            ((TemporaryTopic)this.responseDestination).delete();
                        }
                        catch (JMSException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        if (this.responseDestination instanceof TemporaryQueue) {
            try {
                ((TemporaryQueue)this.responseDestination).delete();
            }
            catch (JMSException e) {}
        } else if (this.responseDestination instanceof TemporaryTopic) {
            try {
                ((TemporaryTopic)this.responseDestination).delete();
            }
            catch (JMSException e) {}
        }
    }

    protected boolean hasResponse() throws IOException {
        return this.responseMessage != null;
    }

    protected Iterator<String> getResponseHeaderNames() throws IOException {
        try {
            return JmsTransportUtils.getHeaderNames(this.responseMessage);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property names", ex);
        }
    }

    protected Iterator<String> getResponseHeaders(String name) throws IOException {
        try {
            return JmsTransportUtils.getHeaders(this.responseMessage, name);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property value", ex);
        }
    }

    protected InputStream getResponseInputStream() throws IOException {
        if (this.responseMessage instanceof BytesMessage) {
            return new BytesMessageInputStream((BytesMessage)this.responseMessage);
        }
        if (this.responseMessage instanceof TextMessage) {
            return new TextMessageInputStream((TextMessage)this.responseMessage, this.textMessageEncoding);
        }
        throw new IllegalStateException("Unknown response message type [" + this.responseMessage + "]");
    }

    protected void onClose() throws IOException {
        JmsUtils.closeSession((Session)this.session);
        ConnectionFactoryUtils.releaseConnection((Connection)this.connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
    }
}

