/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DefaultTimestampValidator
implements TimestampValidationCallback.TimestampValidator {
    public void validate(TimestampValidationCallback.Request request) throws TimestampValidationCallback.TimestampValidationException {
        if (request instanceof TimestampValidationCallback.UTCTimestampRequest) {
            TimestampValidationCallback.UTCTimestampRequest utcRequest = (TimestampValidationCallback.UTCTimestampRequest)request;
            Date created = this.parseDate(utcRequest.getCreated());
            this.validateCreationTime(created, utcRequest.getMaxClockSkew(), utcRequest.getTimestampFreshnessLimit());
            if (utcRequest.getExpired() != null) {
                Date expired = this.parseDate(utcRequest.getExpired());
                this.validateExpirationTime(expired, utcRequest.getMaxClockSkew());
            }
        } else {
            throw new TimestampValidationCallback.TimestampValidationException("Unsupport request: [" + request + "]");
        }
    }

    private Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) {
        GregorianCalendar c = new GregorianCalendar();
        long offset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    private Date getGMTDateWithSkewAdjusted(Calendar calendar, long maxClockSkew, boolean addSkew) {
        long offset = calendar.get(15);
        if (calendar.getTimeZone().inDaylightTime(calendar.getTime())) {
            offset += (long)calendar.getTimeZone().getDSTSavings();
        }
        long beforeTime = calendar.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        calendar.setTimeInMillis(currentTime);
        return calendar.getTime();
    }

    private Date parseDate(String date) throws TimestampValidationCallback.TimestampValidationException {
        SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
        try {
            return calendarFormatter1.parse(date);
        }
        catch (ParseException ignored) {
            try {
                return calendarFormatter2.parse(date);
            }
            catch (ParseException ex) {
                throw new TimestampValidationCallback.TimestampValidationException("Could not parse request date: " + date, (Throwable)ex);
            }
        }
    }

    private void validateCreationTime(Date created, long maxClockSkew, long timestampFreshnessLimit) throws TimestampValidationCallback.TimestampValidationException {
        Date current = this.getFreshnessAndSkewAdjustedDate(maxClockSkew, timestampFreshnessLimit);
        if (created.before(current)) {
            throw new TimestampValidationCallback.TimestampValidationException("The creation time is older than  currenttime - timestamp-freshness-limit - max-clock-skew");
        }
        Date currentTime = this.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, true);
        if (currentTime.before(created)) {
            throw new TimestampValidationCallback.TimestampValidationException("The creation time is ahead of the current time.");
        }
    }

    private void validateExpirationTime(Date expires, long maxClockSkew) throws TimestampValidationCallback.TimestampValidationException {
        Date currentTime = this.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, false);
        if (expires.before(currentTime)) {
            throw new TimestampValidationCallback.TimestampValidationException("The current time is ahead of the expiration time in Timestamp");
        }
    }
}

