/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SignatureTrustValidator;
import org.apache.ws.security.validate.TimestampValidator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.security.AbstractWsSecurityInterceptor;
import org.springframework.ws.soap.security.WsSecuritySecurementException;
import org.springframework.ws.soap.security.WsSecurityValidationException;
import org.springframework.ws.soap.security.callback.CallbackHandlerChain;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.wss4j.Wss4jHandler;
import org.springframework.ws.soap.security.wss4j.Wss4jSecuritySecurementException;
import org.springframework.ws.soap.security.wss4j.Wss4jSecurityValidationException;
import org.springframework.ws.soap.security.wss4j.callback.UsernameTokenPrincipalCallback;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wss4jSecurityInterceptor
extends AbstractWsSecurityInterceptor
implements InitializingBean {
    public static final String SECUREMENT_USER_PROPERTY_NAME = "Wss4jSecurityInterceptor.securementUser";
    private int securementAction;
    private String securementActions;
    private List<Integer> securementActionsVector;
    private String securementUsername;
    private CallbackHandler validationCallbackHandler;
    private int validationAction;
    private String validationActions;
    private List<Integer> validationActionsVector;
    private String validationActor;
    private Crypto validationDecryptionCrypto;
    private Crypto validationSignatureCrypto;
    private boolean timestampStrict = true;
    private boolean enableSignatureConfirmation;
    private int validationTimeToLive = 300;
    private int securementTimeToLive = 300;
    private WSSConfig wssConfig;
    private final Wss4jHandler handler = new Wss4jHandler();
    private final WSSecurityEngine securityEngine = new WSSecurityEngine();
    private boolean enableRevocation;
    private boolean bspCompliant;
    private boolean securementUseDerivedKey;

    public void setSecurementActions(String securementActions) {
        this.securementActions = securementActions;
        this.securementActionsVector = new ArrayList<Integer>();
        try {
            this.securementAction = WSSecurityUtil.decodeAction((String)securementActions, this.securementActionsVector);
        }
        catch (WSSecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setSecurementActor(String securementActor) {
        this.handler.setOption("actor", securementActor);
    }

    public void setSecurementEncryptionCrypto(Crypto securementEncryptionCrypto) {
        this.handler.setSecurementEncryptionCrypto(securementEncryptionCrypto);
    }

    public void setSecurementEncryptionEmbeddedKeyName(String securementEncryptionEmbeddedKeyName) {
        this.handler.setOption("embeddedKeyName", securementEncryptionEmbeddedKeyName);
    }

    public void setSecurementEncryptionKeyIdentifier(String securementEncryptionKeyIdentifier) {
        this.handler.setOption("encryptionKeyIdentifier", securementEncryptionKeyIdentifier);
    }

    public void setSecurementEncryptionKeyTransportAlgorithm(String securementEncryptionKeyTransportAlgorithm) {
        this.handler.setOption("encryptionKeyTransportAlgorithm", securementEncryptionKeyTransportAlgorithm);
    }

    public void setSecurementEncryptionParts(String securementEncryptionParts) {
        this.handler.setOption("encryptionParts", securementEncryptionParts);
    }

    public void setSecurementEncryptionSymAlgorithm(String securementEncryptionSymAlgorithm) {
        this.handler.setOption("encryptionSymAlgorithm", securementEncryptionSymAlgorithm);
    }

    public void setSecurementEncryptionUser(String securementEncryptionUser) {
        this.handler.setOption("encryptionUser", securementEncryptionUser);
    }

    public void setSecurementPassword(String securementPassword) {
        this.handler.setSecurementPassword(securementPassword);
    }

    public void setSecurementPasswordType(String securementUsernameTokenPasswordType) {
        this.handler.setOption("passwordType", securementUsernameTokenPasswordType);
    }

    public void setSecurementSignatureAlgorithm(String securementSignatureAlgorithm) {
        this.handler.setOption("signatureAlgorithm", securementSignatureAlgorithm);
    }

    public void setSecurementSignatureDigestAlgorithm(String digestAlgorithm) {
        this.handler.setOption("signatureDigestAlgorithm", digestAlgorithm);
    }

    public void setSecurementSignatureCrypto(Crypto securementSignatureCrypto) {
        this.handler.setSecurementSignatureCrypto(securementSignatureCrypto);
    }

    public void setSecurementSignatureKeyIdentifier(String securementSignatureKeyIdentifier) {
        this.handler.setOption("signatureKeyIdentifier", securementSignatureKeyIdentifier);
    }

    public void setSecurementSignatureParts(String securementSignatureParts) {
        this.handler.setOption("signatureParts", securementSignatureParts);
    }

    public void setSecurementSignatureUser(String securementSignatureUser) {
        this.handler.setOption("signatureUser", securementSignatureUser);
    }

    public void setSecurementUsername(String securementUsername) {
        this.securementUsername = securementUsername;
    }

    public void setSecurementTimeToLive(int securementTimeToLive) {
        if (securementTimeToLive <= 0) {
            throw new IllegalArgumentException("timeToLive must be positive");
        }
        this.securementTimeToLive = securementTimeToLive;
    }

    public void setSecurementUseDerivedKey(boolean securementUseDerivedKey) {
        this.securementUseDerivedKey = securementUseDerivedKey;
    }

    public void setValidationTimeToLive(int validationTimeToLive) {
        if (validationTimeToLive <= 0) {
            throw new IllegalArgumentException("timeToLive must be positive");
        }
        this.validationTimeToLive = validationTimeToLive;
    }

    public void setValidationActions(String actions) {
        this.validationActions = actions;
        try {
            this.validationActionsVector = new ArrayList<Integer>();
            this.validationAction = WSSecurityUtil.decodeAction((String)actions, this.validationActionsVector);
        }
        catch (WSSecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setValidationActor(String validationActor) {
        this.validationActor = validationActor;
    }

    public void setValidationCallbackHandler(CallbackHandler callbackHandler) {
        this.validationCallbackHandler = callbackHandler;
    }

    public void setValidationCallbackHandlers(CallbackHandler[] callbackHandler) {
        this.validationCallbackHandler = new CallbackHandlerChain(callbackHandler);
    }

    public void setValidationDecryptionCrypto(Crypto decryptionCrypto) {
        this.validationDecryptionCrypto = decryptionCrypto;
    }

    public void setValidationSignatureCrypto(Crypto signatureCrypto) {
        this.validationSignatureCrypto = signatureCrypto;
    }

    public void setEnableSignatureConfirmation(boolean enableSignatureConfirmation) {
        this.handler.setOption("enableSignatureConfirmation", enableSignatureConfirmation);
        this.enableSignatureConfirmation = enableSignatureConfirmation;
    }

    public void setTimestampPrecisionInMilliseconds(boolean timestampPrecisionInMilliseconds) {
        this.handler.setOption("precisionInMilliseconds", timestampPrecisionInMilliseconds);
    }

    public void setTimestampStrict(boolean timestampStrict) {
        this.timestampStrict = timestampStrict;
    }

    public void setSecurementMustUnderstand(boolean securementMustUnderstand) {
        this.handler.setOption("mustUnderstand", securementMustUnderstand);
    }

    public void setSecurementUsernameTokenElements(String securementUsernameTokenElements) {
        this.handler.setOption("addUTElements", securementUsernameTokenElements);
    }

    public void setWssConfig(WSSConfig config) {
        this.securityEngine.setWssConfig(config);
        this.wssConfig = config;
    }

    public void setEnableRevocation(boolean enableRevocation) {
        this.enableRevocation = enableRevocation;
    }

    public void setBspCompliant(boolean bspCompliant) {
        this.bspCompliant = bspCompliant;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.validationActions != null || this.securementActions != null ? 1 : 0) != 0, (String)"validationActions or securementActions are required");
        if (this.validationActions != null) {
            if ((this.validationAction & 1) != 0) {
                Assert.notNull((Object)this.validationCallbackHandler, (String)"validationCallbackHandler is required");
            }
            if ((this.validationAction & 2) != 0) {
                Assert.notNull((Object)this.validationSignatureCrypto, (String)"validationSignatureCrypto is required");
            }
        }
        this.securityEngine.getWssConfig().setAllowNamespaceQualifiedPasswordTypes(true);
        this.securityEngine.getWssConfig().setWsiBSPCompliant(this.bspCompliant);
    }

    @Override
    protected void secureMessage(SoapMessage soapMessage, MessageContext messageContext) throws WsSecuritySecurementException {
        if (this.securementAction == 0 && !this.enableSignatureConfirmation) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Securing message [" + soapMessage + "] with actions [" + this.securementActions + "]"));
        }
        RequestData requestData = this.initializeRequestData(messageContext);
        Document envelopeAsDocument = soapMessage.getDocument();
        try {
            if (this.securementAction == 0) {
                this.securementActionsVector = new ArrayList<Integer>(0);
            }
            this.handler.doSenderAction(this.securementAction, envelopeAsDocument, requestData, this.securementActionsVector, false);
        }
        catch (WSSecurityException ex) {
            throw new Wss4jSecuritySecurementException(ex.getMessage(), ex);
        }
        soapMessage.setDocument(envelopeAsDocument);
    }

    protected RequestData initializeRequestData(MessageContext messageContext) {
        RequestData requestData = new RequestData();
        requestData.setMsgContext((Object)messageContext);
        String contextUsername = (String)messageContext.getProperty(SECUREMENT_USER_PROPERTY_NAME);
        if (StringUtils.hasLength((String)contextUsername)) {
            requestData.setUsername(contextUsername);
        } else {
            requestData.setUsername(this.securementUsername);
        }
        requestData.setTimeToLive(this.securementTimeToLive);
        requestData.setUseDerivedKey(this.securementUseDerivedKey);
        requestData.setWssConfig(this.wssConfig);
        return requestData;
    }

    @Override
    protected void validateMessage(SoapMessage soapMessage, MessageContext messageContext) throws WsSecurityValidationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Validating message [" + soapMessage + "] with actions [" + this.validationActions + "]"));
        }
        if (this.validationAction == 0) {
            return;
        }
        Document envelopeAsDocument = soapMessage.getDocument();
        try {
            List results = this.securityEngine.processSecurityHeader(envelopeAsDocument, this.validationActor, this.validationCallbackHandler, this.validationSignatureCrypto, this.validationDecryptionCrypto);
            if (CollectionUtils.isEmpty((Collection)results)) {
                throw new Wss4jSecurityValidationException("No WS-Security header found");
            }
            this.checkResults(results, this.validationActionsVector);
            this.updateContextWithResults(messageContext, results);
            this.verifyCertificateTrust(results);
            this.verifyTimestamp(results);
            this.processPrincipal(results);
        }
        catch (WSSecurityException ex) {
            throw new Wss4jSecurityValidationException(ex.getMessage(), ex);
        }
        soapMessage.setDocument(envelopeAsDocument);
        soapMessage.getEnvelope().getHeader().removeHeaderElement(WS_SECURITY_NAME);
    }

    protected void checkResults(List<WSSecurityEngineResult> results, List<Integer> validationActions) throws Wss4jSecurityValidationException {
        if (!this.handler.checkReceiverResultsAnyOrder(results, validationActions)) {
            throw new Wss4jSecurityValidationException("Security processing failed (actions mismatch)");
        }
    }

    private void updateContextWithResults(MessageContext messageContext, List<WSSecurityEngineResult> results) {
        ArrayList<WSHandlerResult> handlerResults = (ArrayList<WSHandlerResult>)messageContext.getProperty("RECV_RESULTS");
        if (handlerResults == null) {
            handlerResults = new ArrayList<WSHandlerResult>();
            messageContext.setProperty("RECV_RESULTS", handlerResults);
        }
        WSHandlerResult rResult = new WSHandlerResult(this.validationActor, results);
        handlerResults.add(0, rResult);
        messageContext.setProperty("RECV_RESULTS", handlerResults);
    }

    protected void verifyCertificateTrust(List<WSSecurityEngineResult> results) throws WSSecurityException {
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        if (actionResult != null) {
            X509Certificate returnCert = (X509Certificate)actionResult.get((Object)"x509-certificate");
            Credential credential = new Credential();
            credential.setCertificates(new X509Certificate[]{returnCert});
            RequestData requestData = new RequestData();
            requestData.setSigCrypto(this.validationSignatureCrypto);
            requestData.setEnableRevocation(this.enableRevocation);
            SignatureTrustValidator validator = new SignatureTrustValidator();
            validator.validate(credential, requestData);
        }
    }

    protected void verifyTimestamp(List<WSSecurityEngineResult> results) throws WSSecurityException {
        Timestamp timestamp;
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)32);
        if (actionResult != null && (timestamp = (Timestamp)actionResult.get((Object)"timestamp")) != null && this.timestampStrict) {
            Credential credential = new Credential();
            credential.setTimestamp(timestamp);
            RequestData requestData = new RequestData();
            WSSConfig config = new WSSConfig();
            config.setTimeStampTTL(this.validationTimeToLive);
            config.setTimeStampStrict(this.timestampStrict);
            requestData.setWssConfig(config);
            TimestampValidator validator = new TimestampValidator();
            validator.validate(credential, requestData);
        }
    }

    private void processPrincipal(List<WSSecurityEngineResult> results) {
        Principal principal;
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)1);
        if (actionResult != null && (principal = (Principal)actionResult.get((Object)"principal")) != null && principal instanceof WSUsernameTokenPrincipal) {
            WSUsernameTokenPrincipal usernameTokenPrincipal = (WSUsernameTokenPrincipal)principal;
            UsernameTokenPrincipalCallback callback = new UsernameTokenPrincipalCallback(usernameTokenPrincipal);
            try {
                this.validationCallbackHandler.handle(new Callback[]{callback});
            }
            catch (IOException ex) {
                this.logger.warn((Object)"Principal callback resulted in IOException", (Throwable)ex);
            }
            catch (UnsupportedCallbackException ex) {
                // empty catch block
            }
        }
    }

    @Override
    protected void cleanUp() {
        if (this.validationCallbackHandler != null) {
            try {
                CleanupCallback cleanupCallback = new CleanupCallback();
                this.validationCallbackHandler.handle(new Callback[]{cleanupCallback});
            }
            catch (IOException ex) {
                this.logger.warn((Object)"Cleanup callback resulted in IOException", (Throwable)ex);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                // empty catch block
            }
        }
    }
}

