/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xstream;

import com.thoughtworks.xstream.alias.CannotResolveClassException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.StreamException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.xstream.XStreamMarshallingFailureException;
import org.springframework.oxm.xstream.XStreamSystemException;
import org.springframework.oxm.xstream.XStreamUnmarshallingFailureException;

public abstract class XStreamUtils {
    public static XmlMappingException convertXStreamException(Exception ex, boolean marshalling) {
        if (ex instanceof StreamException) {
            if (marshalling) {
                return new XStreamMarshallingFailureException((StreamException)ex);
            }
            return new XStreamUnmarshallingFailureException((StreamException)ex);
        }
        if (ex instanceof CannotResolveClassException) {
            if (marshalling) {
                return new XStreamMarshallingFailureException((CannotResolveClassException)ex);
            }
            return new XStreamUnmarshallingFailureException((CannotResolveClassException)ex);
        }
        if (ex instanceof ConversionException) {
            if (marshalling) {
                return new XStreamMarshallingFailureException((ConversionException)ex);
            }
            return new XStreamUnmarshallingFailureException((ConversionException)ex);
        }
        return new XStreamSystemException("Unknown XStream exception: " + ex.getMessage(), ex);
    }
}

