/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.factory;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.ConditionalFlowExecutionListenerHolder;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteria;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteriaFactory;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;

public class ConditionalFlowExecutionListenerLoader
implements FlowExecutionListenerLoader {
    private final Log logger = LogFactory.getLog(ConditionalFlowExecutionListenerLoader.class);
    private List listeners = new LinkedList();

    public void addListener(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        ConditionalFlowExecutionListenerHolder conditional;
        if (listener == null) {
            throw new IllegalArgumentException("The flow execution listener cannot be null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding flow execution listener " + listener + " with criteria " + criteria));
        }
        if ((conditional = this.getHolder(listener)) == null) {
            conditional = new ConditionalFlowExecutionListenerHolder(listener);
            this.listeners.add(conditional);
        }
        if (criteria == null) {
            criteria = new FlowExecutionListenerCriteriaFactory().allFlows();
        }
        conditional.add(criteria);
    }

    public FlowExecutionListener[] getListeners(FlowDefinition flowDefinition) {
        Assert.notNull((Object)flowDefinition, (String)"The Flow to load listeners for cannot be null");
        LinkedList<FlowExecutionListener> listenersToAttach = new LinkedList<FlowExecutionListener>();
        for (ConditionalFlowExecutionListenerHolder listenerHolder : this.listeners) {
            if (!listenerHolder.listenerAppliesTo(flowDefinition)) continue;
            listenersToAttach.add(listenerHolder.getListener());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded [" + listenersToAttach.size() + "] of possible " + this.listeners.size() + " listeners for this execution request for flow '" + flowDefinition.getId() + "', the listeners to attach are " + StylerUtils.style(listenersToAttach)));
        }
        return listenersToAttach.toArray(new FlowExecutionListener[listenersToAttach.size()]);
    }

    private ConditionalFlowExecutionListenerHolder getHolder(FlowExecutionListener listener) {
        for (ConditionalFlowExecutionListenerHolder next : this.listeners) {
            if (!next.getListener().equals(listener)) continue;
            return next;
        }
        return null;
    }
}

