/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.builder.xml;

import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class WebFlowEntityResolver
implements EntityResolver {
    private static final String[] WEBFLOW_VERSIONS = new String[]{"spring-webflow-2.0"};

    WebFlowEntityResolver() {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null && systemId.indexOf("spring-webflow.xsd") > -1) {
            return this.createInputSource(publicId, systemId, String.valueOf(WEBFLOW_VERSIONS[0]) + ".xsd");
        }
        int i = 0;
        while (i < WEBFLOW_VERSIONS.length) {
            if (systemId != null && systemId.indexOf(WEBFLOW_VERSIONS[i]) > systemId.lastIndexOf("/")) {
                String fileName = systemId.substring(systemId.indexOf(WEBFLOW_VERSIONS[i]));
                return this.createInputSource(publicId, systemId, fileName);
            }
            ++i;
        }
        return null;
    }

    private InputSource createInputSource(String publicId, String systemId, String fileName) {
        try {
            ClassPathResource resource = new ClassPathResource(fileName, this.getClass());
            InputSource source = new InputSource(resource.getInputStream());
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

