/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.config;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.faces.model.converter.FacesConversionService;
import org.springframework.faces.webflow.FacesSpringELExpressionParser;
import org.springframework.faces.webflow.JsfViewFactoryCreator;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser;
import org.springframework.webflow.validation.ValidationHintResolver;

public class FlowBuilderServicesBuilder {
    private boolean enableManagedBeans = false;
    private ConversionService conversionService = new FacesConversionService();
    private ExpressionParser expressionParser;
    private ViewFactoryCreator viewFactoryCreator = new JsfViewFactoryCreator();
    private Validator validator;
    private ValidationHintResolver validationHintResolver;
    private boolean enableDevelopmentMode;

    public FlowBuilderServicesBuilder setEnableManagedBeans(boolean enableManagedBeans) {
        this.enableManagedBeans = enableManagedBeans;
        return this;
    }

    public FlowBuilderServicesBuilder setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
        return this;
    }

    public FlowBuilderServicesBuilder setExpressionParser(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
        return this;
    }

    public FlowBuilderServicesBuilder setViewFactoryCreator(ViewFactoryCreator viewFactoryCreator) {
        this.viewFactoryCreator = viewFactoryCreator;
        return this;
    }

    public FlowBuilderServicesBuilder setValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public FlowBuilderServicesBuilder setValidationHintResolver(ValidationHintResolver resolver) {
        this.validationHintResolver = resolver;
        return this;
    }

    public FlowBuilderServicesBuilder setDevelopmentMode(boolean enableDevelopmentMode) {
        this.enableDevelopmentMode = enableDevelopmentMode;
        return this;
    }

    public FlowBuilderServices build() {
        FlowBuilderServices flowBuilderServices = new FlowBuilderServices();
        flowBuilderServices.setConversionService(this.conversionService);
        flowBuilderServices.setExpressionParser(this.getExpressionParser());
        flowBuilderServices.setViewFactoryCreator(this.viewFactoryCreator);
        flowBuilderServices.setValidator(this.validator);
        flowBuilderServices.setValidationHintResolver(this.validationHintResolver);
        flowBuilderServices.setDevelopment(this.enableDevelopmentMode);
        return flowBuilderServices;
    }

    private ExpressionParser getExpressionParser() {
        if (this.expressionParser != null) {
            Assert.isTrue((!this.enableManagedBeans ? 1 : 0) != 0, (String)"Do not specify a custom expression-parser when enable-managed-beans is true");
            return this.expressionParser;
        }
        return this.enableManagedBeans ? new FacesSpringELExpressionParser(new SpelExpressionParser(), this.conversionService) : new WebFlowSpringELExpressionParser(new SpelExpressionParser(), this.conversionService);
    }
}

