/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.security;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.security.taglibs.authz.AbstractAuthorizeTag;

public class FaceletsAuthorizeTag
extends AbstractAuthorizeTag {
    public FaceletsAuthorizeTag(FaceletContext faceletContext, TagAttribute access, TagAttribute url, TagAttribute method, TagAttribute ifAllGranted, TagAttribute ifAnyGranted, TagAttribute ifNotGranted) {
        this.setAccess(this.getAttributeValue(faceletContext, access, false));
        this.setUrl(this.getAttributeValue(faceletContext, url, true));
        this.setMethod(this.getAttributeValue(faceletContext, method, true));
        this.setIfAllGranted(this.getAttributeValue(faceletContext, ifAllGranted, true));
        this.setIfAnyGranted(this.getAttributeValue(faceletContext, ifAnyGranted, true));
        this.setIfNotGranted(this.getAttributeValue(faceletContext, ifNotGranted, true));
    }

    public FaceletsAuthorizeTag() {
    }

    protected ServletRequest getRequest() {
        return (ServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }

    protected ServletResponse getResponse() {
        return (ServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
    }

    protected ServletContext getServletContext() {
        return (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
    }

    private String getAttributeValue(FaceletContext faceletContext, TagAttribute tagAttribute, boolean evaluate) {
        String value = null;
        if (tagAttribute != null) {
            if (evaluate) {
                ValueExpression expression = tagAttribute.getValueExpression(faceletContext, String.class);
                value = (String)expression.getValue(faceletContext.getFacesContext().getELContext());
            } else {
                value = tagAttribute.getValue();
            }
        }
        return value;
    }
}

