/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.service;

import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class StaticConversionExecutor
implements ConversionExecutor {
    private final Class<?> sourceClass;
    private final Class<?> targetClass;
    private final Converter converter;

    public StaticConversionExecutor(Class<?> sourceClass, Class<?> targetClass, Converter converter) {
        Assert.notNull(sourceClass, (String)"The source class is required");
        Assert.notNull(targetClass, (String)"The target class is required");
        Assert.notNull((Object)converter, (String)"The converter is required");
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.converter = converter;
    }

    @Override
    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public Object execute(Object source) throws ConversionExecutionException {
        if (source != null && !this.sourceClass.isInstance(source)) {
            throw new ConversionExecutionException(source, this.getSourceClass(), this.getTargetClass(), "Source object " + String.valueOf(source) + " to convert is expected to be an instance of [" + this.getSourceClass().getName() + "]");
        }
        try {
            return this.converter.convertSourceToTargetClass(source, this.targetClass);
        }
        catch (Exception e) {
            throw new ConversionExecutionException(source, this.getSourceClass(), this.getTargetClass(), e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof StaticConversionExecutor)) {
            return false;
        }
        StaticConversionExecutor other = (StaticConversionExecutor)o;
        return this.sourceClass.equals(other.sourceClass) && this.targetClass.equals(other.targetClass);
    }

    public int hashCode() {
        return this.sourceClass.hashCode() + this.targetClass.hashCode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("sourceClass", this.sourceClass).append("targetClass", this.targetClass).toString();
    }
}

