/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.boot.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.statemachine.boot.StateMachineProperties;
import org.springframework.statemachine.boot.support.BootStateMachineMonitor;

@Configuration
@EnableConfigurationProperties(value={StateMachineProperties.class})
public class StateMachineAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={CounterService.class})
    @ConditionalOnProperty(prefix="spring.statemachine.monitor", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class StateMachineMonitoringConfiguration {
        private final CounterService counterService;
        private final GaugeService gaugeService;
        private final TraceRepository traceRepository;

        public StateMachineMonitoringConfiguration(ObjectProvider<CounterService> counterServiceProvider, ObjectProvider<GaugeService> gaugeServiceProvider, ObjectProvider<TraceRepository> traceRepositoryProvider) {
            this.counterService = (CounterService)counterServiceProvider.getIfAvailable();
            this.gaugeService = (GaugeService)gaugeServiceProvider.getIfAvailable();
            this.traceRepository = (TraceRepository)traceRepositoryProvider.getIfAvailable();
        }

        @Bean
        public BootStateMachineMonitor<?, ?> bootStateMachineMonitor() {
            return new BootStateMachineMonitor(this.counterService, this.gaugeService, this.traceRepository);
        }
    }
}

