/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.transaction.external.ExternalTransactionConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.ClassUtils;

public class SqlMapClientFactoryBean
implements FactoryBean,
InitializingBean {
    private static final boolean buildSqlMapClientWithInputStreamMethodAvailable = ClassUtils.hasMethod(SqlMapClientBuilder.class, "buildSqlMapClient", new Class[]{InputStream.class});
    private static final boolean buildSqlMapClientWithInputStreamAndPropertiesMethodAvailable = ClassUtils.hasMethod(SqlMapClientBuilder.class, "buildSqlMapClient", new Class[]{InputStream.class, Properties.class});
    private static final ThreadLocal configTimeLobHandlerHolder = new ThreadLocal();
    private Resource configLocation;
    private Properties sqlMapClientProperties;
    private DataSource dataSource;
    private boolean useTransactionAwareDataSource = true;
    private Class transactionConfigClass = ExternalTransactionConfig.class;
    private Properties transactionConfigProperties = new Properties();
    private LobHandler lobHandler;
    private SqlMapClient sqlMapClient;

    public static LobHandler getConfigTimeLobHandler() {
        return (LobHandler)configTimeLobHandlerHolder.get();
    }

    public SqlMapClientFactoryBean() {
        this.transactionConfigProperties.setProperty("SetAutoCommitAllowed", "false");
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setSqlMapClientProperties(Properties sqlMapClientProperties) {
        this.sqlMapClientProperties = sqlMapClientProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUseTransactionAwareDataSource(boolean useTransactionAwareDataSource) {
        this.useTransactionAwareDataSource = useTransactionAwareDataSource;
    }

    public void setTransactionConfigClass(Class transactionConfigClass) {
        if (transactionConfigClass == null || !TransactionConfig.class.isAssignableFrom(transactionConfigClass)) {
            throw new IllegalArgumentException("Invalid transactionConfigClass: does not implement com.ibatis.sqlmap.engine.transaction.TransactionConfig");
        }
        this.transactionConfigClass = transactionConfigClass;
    }

    public void setTransactionConfigProperties(Properties transactionConfigProperties) {
        this.transactionConfigProperties = transactionConfigProperties;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.configLocation == null) {
            throw new IllegalArgumentException("configLocation is required");
        }
        if (this.lobHandler != null) {
            configTimeLobHandlerHolder.set(this.lobHandler);
        }
        try {
            this.sqlMapClient = this.buildSqlMapClient(this.configLocation, this.sqlMapClientProperties);
            if (this.dataSource != null) {
                TransactionConfig transactionConfig = (TransactionConfig)this.transactionConfigClass.newInstance();
                DataSource dataSourceToUse = this.dataSource;
                if (this.useTransactionAwareDataSource && !(this.dataSource instanceof TransactionAwareDataSourceProxy)) {
                    dataSourceToUse = new TransactionAwareDataSourceProxy(this.dataSource);
                }
                transactionConfig.setDataSource(dataSourceToUse);
                transactionConfig.initialize(this.transactionConfigProperties);
                this.applyTransactionConfig(this.sqlMapClient, transactionConfig);
            }
            Object var4_3 = null;
            if (this.lobHandler != null) {
                configTimeLobHandlerHolder.set(null);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.lobHandler != null) {
                configTimeLobHandlerHolder.set(null);
            }
            throw throwable;
        }
    }

    protected SqlMapClient buildSqlMapClient(Resource configLocation, Properties properties) throws IOException {
        InputStream is = configLocation.getInputStream();
        if (properties != null) {
            if (buildSqlMapClientWithInputStreamAndPropertiesMethodAvailable) {
                return SqlMapClientBuilder.buildSqlMapClient((InputStream)is, (Properties)properties);
            }
            return SqlMapClientBuilder.buildSqlMapClient((Reader)new InputStreamReader(is), (Properties)properties);
        }
        if (buildSqlMapClientWithInputStreamMethodAvailable) {
            return SqlMapClientBuilder.buildSqlMapClient((InputStream)is);
        }
        return SqlMapClientBuilder.buildSqlMapClient((Reader)new InputStreamReader(is));
    }

    protected void applyTransactionConfig(SqlMapClient sqlMapClient, TransactionConfig transactionConfig) {
        if (!(this.sqlMapClient instanceof ExtendedSqlMapClient)) {
            throw new IllegalArgumentException("Cannot set TransactionConfig with DataSource for SqlMapClient if not of type ExtendedSqlMapClient: " + this.sqlMapClient);
        }
        ExtendedSqlMapClient extendedClient = (ExtendedSqlMapClient)this.sqlMapClient;
        transactionConfig.setMaximumConcurrentTransactions(extendedClient.getDelegate().getMaxTransactions());
        extendedClient.getDelegate().setTxManager(new TransactionManager(transactionConfig));
    }

    public Object getObject() {
        return this.sqlMapClient;
    }

    public Class getObjectType() {
        return this.sqlMapClient != null ? this.sqlMapClient.getClass() : SqlMapClient.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

