/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingFacesELResolver
extends ELResolver {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Object getValue(ELContext elContext, Object base, Object property) throws ELException {
        if (base == null) {
            BeanFactory bf;
            String beanName = property.toString();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Attempting to resolve variable '" + beanName + "' in root WebApplicationContext"));
            }
            if ((bf = this.getBeanFactory(elContext)).containsBean(beanName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Successfully resolved variable '" + beanName + "' in root WebApplicationContext"));
                }
                elContext.setPropertyResolved(true);
                return bf.getBean(beanName);
            }
        }
        return null;
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) throws ELException {
        if (base == null) {
            BeanFactory bf;
            String name = property.toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Attempting to resolve variable '" + name + "' in root WebApplicationContext"));
            }
            if ((bf = this.getBeanFactory(elContext)).containsBean(name)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Successfully resolved variable '" + name + "' in root WebApplicationContext"));
                }
                elContext.setPropertyResolved(true);
                return bf.getType(name);
            }
        }
        return null;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) throws ELException {
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) throws ELException {
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        return Object.class;
    }

    protected BeanFactory getBeanFactory(ELContext elContext) {
        return this.getWebApplicationContext(elContext);
    }

    protected WebApplicationContext getWebApplicationContext(ELContext elContext) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return FacesContextUtils.getRequiredWebApplicationContext(facesContext);
    }
}

