/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.annotation;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jmx.export.annotation.AnnotationMBeanExporter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MBeanExportBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MBEAN_EXPORTER_BEAN_NAME = "mbeanExporter";
    private static final String DEFAULT_DOMAIN_ATTRIBUTE = "default-domain";
    private static final String SERVER_ATTRIBUTE = "server";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return MBEAN_EXPORTER_BEAN_NAME;
    }

    protected String getBeanClassName(Element element) {
        return AnnotationMBeanExporter.class.getName();
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String serverBeanName;
        builder.setRole(2);
        String defaultDomain = element.getAttribute(DEFAULT_DOMAIN_ATTRIBUTE);
        if (StringUtils.hasText(defaultDomain)) {
            builder.addPropertyValue("defaultDomain", defaultDomain);
        }
        if (StringUtils.hasText(serverBeanName = element.getAttribute(SERVER_ATTRIBUTE))) {
            builder.addPropertyReference(SERVER_ATTRIBUTE, serverBeanName);
        }
    }
}

