/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import java.io.IOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenPersistenceManagerInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_PERSISTENCE_MANAGER_FACTORY_BEAN_NAME = "persistenceManagerFactory";
    private String persistenceManagerFactoryBeanName = "persistenceManagerFactory";
    static /* synthetic */ Class class$javax$jdo$PersistenceManagerFactory;

    public void setPersistenceManagerFactoryBeanName(String persistenceManagerFactoryBeanName) {
        this.persistenceManagerFactoryBeanName = persistenceManagerFactoryBeanName;
    }

    protected String getPersistenceManagerFactoryBeanName() {
        return this.persistenceManagerFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        PersistenceManagerFactory pmf = this.lookupPersistenceManagerFactory(request);
        PersistenceManager pm = null;
        boolean participate = false;
        if (TransactionSynchronizationManager.hasResource(pmf)) {
            participate = true;
        } else {
            this.logger.debug((Object)"Opening JDO PersistenceManager in OpenPersistenceManagerInViewFilter");
            pm = PersistenceManagerFactoryUtils.getPersistenceManager(pmf, true);
            TransactionSynchronizationManager.bindResource(pmf, new PersistenceManagerHolder(pm));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                TransactionSynchronizationManager.unbindResource(pmf);
                this.logger.debug((Object)"Closing JDO PersistenceManager in OpenPersistenceManagerInViewFilter");
                PersistenceManagerFactoryUtils.releasePersistenceManager(pm, pmf);
            }
        }
    }

    protected PersistenceManagerFactory lookupPersistenceManagerFactory(HttpServletRequest request) {
        return this.lookupPersistenceManagerFactory();
    }

    protected PersistenceManagerFactory lookupPersistenceManagerFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using PersistenceManagerFactory '" + this.getPersistenceManagerFactoryBeanName() + "' for OpenPersistenceManagerInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        return (PersistenceManagerFactory)wac.getBean(this.getPersistenceManagerFactoryBeanName(), class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = OpenPersistenceManagerInViewFilter.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

