/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.destination;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.jms.support.JmsAccessor;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.util.Assert;

public class JmsDestinationAccessor
extends JmsAccessor {
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private boolean pubSubDomain = false;

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull(destinationResolver, "DestinationResolver must not be null");
        this.destinationResolver = destinationResolver;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    protected Destination resolveDestinationName(Session session, String destinationName) throws JMSException {
        return this.getDestinationResolver().resolveDestinationName(session, destinationName, this.isPubSubDomain());
    }
}

