/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AbstractAspectJAdvice;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;

public class AspectJPointcutAdvisor
extends DefaultPointcutAdvisor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPointcut(Pointcut pointcut) {
        if (!(pointcut instanceof AspectJExpressionPointcut)) {
            throw new IllegalArgumentException("AspectJPointcutAdvisor requires an AspectJExpressionPointcut but was passed an instance of '" + pointcut.getClass().getName() + "'");
        }
        AspectJExpressionPointcut newPointcut = (AspectJExpressionPointcut)pointcut;
        Advice myAdvice = this.getAdvice();
        if (myAdvice instanceof AbstractAspectJAdvice) {
            AbstractAspectJAdvice myAjAdvice = (AbstractAspectJAdvice)((Object)myAdvice);
            String adviceExpression = myAjAdvice.getPointcut().getExpression();
            if (!newPointcut.getExpression().equals(adviceExpression)) throw new IllegalStateException("Pointcut expression in advisor must match expression in associated advice:\nexpression is '" + newPointcut.getExpression() + "'\n" + "and expression in advice is '" + adviceExpression + "'");
            super.setPointcut(myAjAdvice.getPointcut());
            return;
        } else {
            super.setPointcut(newPointcut);
        }
    }

    public void setAdvice(Advice advice) {
        super.setAdvice(advice);
        if (advice instanceof AbstractAspectJAdvice) {
            AbstractAspectJAdvice ajAdvice = (AbstractAspectJAdvice)((Object)advice);
            this.ensureAdviceAndPointcutReferToSamePointcutInstance(ajAdvice);
            this.setOrder(ajAdvice.getOrder());
        }
    }

    private void ensureAdviceAndPointcutReferToSamePointcutInstance(AbstractAspectJAdvice ajAdvice) {
        AspectJExpressionPointcut ajPointcut;
        if (this.getPointcut() != null && !(ajPointcut = (AspectJExpressionPointcut)this.getPointcut()).getExpression().equals(ajAdvice.getPointcut().getExpression())) {
            String msg = "Pointcut expression in advisor must match expression in associated advice:\nexpression is '" + ajPointcut.getExpression() + "'\n" + "and expression in advice is '" + ajAdvice.getPointcut().getExpression() + "'";
            throw new IllegalStateException(msg);
        }
        this.setPointcut(ajAdvice.getPointcut());
    }
}

