/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class CommonsMultipartResolver
extends CommonsFileUploadSupport
implements MultipartResolver,
ServletContextAware {
    private final boolean commonsFileUpload12Present = ClassUtils.hasMethod(class$org$apache$commons$fileupload$servlet$ServletFileUpload == null ? (class$org$apache$commons$fileupload$servlet$ServletFileUpload = CommonsMultipartResolver.class$("org.apache.commons.fileupload.servlet.ServletFileUpload")) : class$org$apache$commons$fileupload$servlet$ServletFileUpload, "isMultipartContent", new Class[]{class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = CommonsMultipartResolver.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest});
    static /* synthetic */ Class class$org$apache$commons$fileupload$servlet$ServletFileUpload;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;

    public CommonsMultipartResolver() {
    }

    public CommonsMultipartResolver(ServletContext servletContext) {
        this();
        this.setServletContext(servletContext);
    }

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        return new ServletFileUpload(fileItemFactory);
    }

    public void setServletContext(ServletContext servletContext) {
        if (!this.isUploadTempDirSpecified()) {
            this.getFileItemFactory().setRepository(WebUtils.getTempDir(servletContext));
        }
    }

    public boolean isMultipart(HttpServletRequest request) {
        if (this.commonsFileUpload12Present) {
            return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        }
        return ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext(request));
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        String encoding = this.determineEncoding(request);
        FileUpload fileUpload = this.prepareFileUpload(encoding);
        try {
            List fileItems = ((ServletFileUpload)fileUpload).parseRequest(request);
            CommonsFileUploadSupport.MultipartParsingResult parsingResult = this.parseFileItems(fileItems, encoding);
            return new DefaultMultipartHttpServletRequest(request, parsingResult.getMultipartFiles(), parsingResult.getMultipartParameters());
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Could not parse multipart servlet request", ex);
        }
    }

    protected String determineEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return encoding;
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        this.cleanupFileItems(request.getFileMap().values());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

