/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import org.springframework.orm.toplink.TopLinkCallback;

public abstract class SessionReadCallback
implements TopLinkCallback {
    private final boolean enforceReadOnly;

    public SessionReadCallback() {
        this.enforceReadOnly = false;
    }

    public SessionReadCallback(boolean enforceReadOnly) {
        this.enforceReadOnly = enforceReadOnly;
    }

    public final Object doInTopLink(Session session) throws TopLinkException {
        UnitOfWork unitOfWork;
        Session sessionToUse = session;
        if (!this.enforceReadOnly && (unitOfWork = session.getActiveUnitOfWork()) != null) {
            sessionToUse = unitOfWork;
        }
        return this.readFromSession(sessionToUse);
    }

    protected abstract Object readFromSession(Session var1) throws TopLinkException;
}

