/*
 * Copyright 2002-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.beans.factory.support;

import org.springframework.beans.factory.config.BeanDefinition;

/**
 * Default implementation of the {@link BeanNameGenerator} interface, delegating to
 * {@link BeanDefinitionReaderUtils#generateBeanName(AbstractBeanDefinition, BeanDefinitionRegistry)}.
 *
 * <p>Note: This implementation is only able to handle {@link AbstractBeanDefinition}
 * subclasses such as {@link RootBeanDefinition} and {@link ChildBeanDefinition}.
 *
 * @author Juergen Hoeller
 * @since 2.0.3
 */
public class DefaultBeanNameGenerator implements BeanNameGenerator {

	public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
		if (!(definition instanceof AbstractBeanDefinition)) {
			throw new IllegalArgumentException(
					"DefaultBeanNameGenerator is only able to handle AbstractBeanDefinition subclasses: " + definition);
		}
		return BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition) definition, registry);
	}

}
