/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public abstract class AbstractRefreshableWebApplicationContext
extends AbstractRefreshableApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    private ServletContext servletContext;
    private ServletConfig servletConfig;
    private String namespace;
    private String[] configLocations;
    private ThemeSource themeSource;
    static /* synthetic */ Class class$org$springframework$web$context$ServletContextAware;
    static /* synthetic */ Class class$org$springframework$web$context$ServletConfigAware;

    public AbstractRefreshableWebApplicationContext() {
        this.setDisplayName("Root WebApplicationContext");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (servletConfig != null && this.servletContext == null) {
            this.servletContext = servletConfig.getServletContext();
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    protected String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocations(String[] locations) {
        this.configLocations = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            this.configLocations[i] = this.resolvePath(locations[i]);
        }
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    public void refresh() throws BeansException {
        if (ObjectUtils.isEmpty(this.getConfigLocations())) {
            this.setConfigLocations(this.getDefaultConfigLocations());
        }
        super.refresh();
    }

    protected String[] getDefaultConfigLocations() {
        return null;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope("request", new RequestScope());
        beanFactory.registerScope("session", new SessionScope(false));
        beanFactory.registerScope("globalSession", new SessionScope(true));
        beanFactory.addBeanPostProcessor(new ServletContextAwareProcessor(this.servletContext, this.servletConfig));
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$context$ServletContextAware == null ? (class$org$springframework$web$context$ServletContextAware = AbstractRefreshableWebApplicationContext.class$("org.springframework.web.context.ServletContextAware")) : class$org$springframework$web$context$ServletContextAware);
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$context$ServletConfigAware == null ? (class$org$springframework$web$context$ServletConfigAware = AbstractRefreshableWebApplicationContext.class$("org.springframework.web.context.ServletConfigAware")) : class$org$springframework$web$context$ServletConfigAware);
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }

    protected Resource getResourceByPath(String path) {
        return new ServletContextResource(this.servletContext, path);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver(this);
    }

    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource(this);
    }

    public Theme getTheme(String themeName) {
        return this.themeSource.getTheme(themeName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("; ");
        sb.append("config locations [");
        sb.append(StringUtils.arrayToCommaDelimitedString(this.configLocations));
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

