/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.ObjectUtils;

public class TransactionAttributeSourceAdvisor
extends AbstractPointcutAdvisor {
    private final TransactionAttributeSourcePointcut pointcut = new TransactionAttributeSourcePointcut();
    private TransactionInterceptor transactionInterceptor;

    public TransactionAttributeSourceAdvisor() {
    }

    public TransactionAttributeSourceAdvisor(TransactionInterceptor interceptor) {
        this.setTransactionInterceptor(interceptor);
    }

    public void setTransactionInterceptor(TransactionInterceptor interceptor) {
        if (interceptor.getTransactionAttributeSource() == null) {
            throw new IllegalArgumentException("Cannot construct a TransactionAttributeSourceAdvisor using a TransactionInterceptor that has no TransactionAttributeSource configured");
        }
        this.transactionInterceptor = interceptor;
    }

    public void setClassFilter(ClassFilter classFilter) {
        this.pointcut.setClassFilter(classFilter);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.transactionInterceptor;
    }

    private class TransactionAttributeSourcePointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        private TransactionAttributeSourcePointcut() {
        }

        private TransactionAttributeSource getTransactionAttributeSource() {
            return TransactionAttributeSourceAdvisor.this.transactionInterceptor.getTransactionAttributeSource();
        }

        public boolean matches(Method method, Class targetClass) {
            return this.getTransactionAttributeSource().getTransactionAttribute(method, targetClass) != null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransactionAttributeSourcePointcut)) {
                return false;
            }
            TransactionAttributeSourcePointcut otherPc = (TransactionAttributeSourcePointcut)other;
            return ObjectUtils.nullSafeEquals(this.getTransactionAttributeSource(), otherPc.getTransactionAttributeSource());
        }

        public int hashCode() {
            TransactionAttributeSource tas = this.getTransactionAttributeSource();
            return tas != null ? tas.hashCode() : 0;
        }
    }
}

