/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class OpenEntityManagerInViewInterceptor
implements WebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private EntityManagerFactory entityManagerFactory;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        if (TransactionSynchronizationManager.hasResource(this.getEntityManagerFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), new Integer(newCount), 0);
        } else {
            this.logger.debug((Object)"Opening JPA EntityManager in OpenEntityManagerInViewInterceptor");
            try {
                EntityManager em = this.createEntityManager();
                TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), new EntityManagerHolder(em));
            }
            catch (PersistenceException ex) {
                throw new DataAccessResourceFailureException("Could not create JPA EntityManager", ex);
            }
        }
    }

    public void postHandle(WebRequest request, ModelMap model) {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, new Integer(count - 1), 0);
            } else {
                request.removeAttribute(participateAttributeName, 0);
            }
        } else {
            EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
            this.logger.debug((Object)"Closing JPA EntityManager in OpenEntityManagerInViewInterceptor");
            emHolder.getEntityManager().close();
        }
    }

    protected String getParticipateAttributeName() {
        return this.getEntityManagerFactory().toString() + PARTICIPATE_SUFFIX;
    }

    protected EntityManager createEntityManager() {
        return this.getEntityManagerFactory().createEntityManager();
    }
}

