/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.jdbc.datasource.lookup.MapDataSourceLookup;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.PersistenceUnitReader;
import org.springframework.orm.jpa.SpringPersistenceUnitInfo;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalContainerEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean
implements ResourceLoaderAware {
    public static final String DEFAULT_PERSISTENCE_XML_LOCATION = "classpath*:META-INF/persistence.xml";
    public static final String DEFAULT_PERSISTENCE_UNIT_ROOT_LOCATION = "classpath:";
    private static Set<String> entityManagerFactoryNamesDeployed = new HashSet<String>();
    private String persistenceXmlLocation = "classpath*:META-INF/persistence.xml";
    private String persistenceUnitRootLocation = "classpath:";
    private boolean allowRedeploymentWithSameName = false;
    private LoadTimeWeaver loadTimeWeaver;
    private DataSource dataSource;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private SpringPersistenceUnitInfo persistenceUnitInfo;

    public void setPersistenceXmlLocation(String persistenceXmlLocation) {
        this.persistenceXmlLocation = persistenceXmlLocation;
    }

    public void setPersistenceUnitRootLocation(String persistenceUnitRootPath) {
        this.persistenceUnitRootLocation = persistenceUnitRootPath;
    }

    public void setAllowRedeploymentWithSameName(boolean allowRedeploymentWithSameName) {
        this.allowRedeploymentWithSameName = allowRedeploymentWithSameName;
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        this.dataSourceLookup = new MapDataSourceLookup(dataSources);
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = resourceLoader != null ? ResourcePatternUtils.getResourcePatternResolver(resourceLoader) : new PathMatchingResourcePatternResolver();
    }

    @Override
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        this.persistenceUnitInfo = this.determinePersistenceUnitInfo();
        this.postProcessPersistenceUnitInfo(this.persistenceUnitInfo);
        String unitName = this.persistenceUnitInfo.getPersistenceUnitName();
        if (!this.allowRedeploymentWithSameName) {
            if (entityManagerFactoryNamesDeployed.contains(unitName)) {
                throw new IllegalStateException("EntityManagerFactory with name '" + unitName + "' " + "has already been deployed in this class loader; cannot deploy another");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Allowing redeployment of EntityManagerFactory with name '" + unitName + "' "));
            }
        }
        entityManagerFactoryNamesDeployed.add(unitName);
        this.persistenceUnitInfo.setLoadTimeWeaver(this.loadTimeWeaver);
        if (this.persistenceUnitInfo.getNonJtaDataSource() == null) {
            this.persistenceUnitInfo.setNonJtaDataSource(this.dataSource);
        }
        if (this.persistenceUnitInfo.getPersistenceUnitRootUrl() == null) {
            this.persistenceUnitInfo.setPersistenceUnitRootUrl(this.determinePersistenceUnitRootUrl());
        }
        Class persistenceProviderClass = this.getPersistenceProviderClass();
        String puiProviderClassName = this.persistenceUnitInfo.getPersistenceProviderClassName();
        if (persistenceProviderClass == null && puiProviderClassName != null) {
            try {
                persistenceProviderClass = ClassUtils.forName(puiProviderClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Cannot resolve provider class name '" + puiProviderClassName + "'", ex);
            }
        }
        if (persistenceProviderClass == null) {
            throw new IllegalStateException("Unable to determine persistence provider class. Please check configuration of " + this.getClass().getName() + "; " + "ideally specify the appropriate JpaVendorAdapter class for this provider");
        }
        PersistenceProvider pp = (PersistenceProvider)BeanUtils.instantiateClass(persistenceProviderClass);
        this.nativeEntityManagerFactory = pp.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceUnitInfo, this.getJpaPropertyMap());
        this.postProcessEntityManagerFactory(this.nativeEntityManagerFactory, this.persistenceUnitInfo);
        return this.nativeEntityManagerFactory;
    }

    protected SpringPersistenceUnitInfo determinePersistenceUnitInfo() {
        SpringPersistenceUnitInfo pui;
        block4: {
            SpringPersistenceUnitInfo[] infos;
            block3: {
                infos = this.readPersistenceUnitInfos();
                if (infos.length == 0) {
                    throw new IllegalArgumentException("No persistence units parsed from [" + this.persistenceXmlLocation + "]");
                }
                pui = null;
                if (this.getPersistenceUnitName() != null) break block3;
                pui = infos[0];
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)("No persistence unit name specified; choosing the first one " + pui.getPersistenceUnitName()));
                break block4;
            }
            for (SpringPersistenceUnitInfo candidate : infos) {
                if (!this.getPersistenceUnitName().equals(candidate.getPersistenceUnitName())) continue;
                pui = candidate;
                break;
            }
        }
        if (pui == null) {
            throw new IllegalArgumentException("No persistence info with name matching '" + this.getPersistenceUnitName() + "' found");
        }
        return pui;
    }

    protected SpringPersistenceUnitInfo[] readPersistenceUnitInfos() {
        PersistenceUnitReader reader = new PersistenceUnitReader(this.resourcePatternResolver, this.dataSourceLookup);
        return reader.readPersistenceUnitInfos(this.persistenceXmlLocation);
    }

    private URL determinePersistenceUnitRootUrl() {
        try {
            Resource res = this.resourcePatternResolver.getResource(this.persistenceUnitRootLocation);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using persistence unit root location: " + res));
            }
            return res.getURL();
        }
        catch (IOException ex) {
            throw new PersistenceException("Unable to resolve persistence unit root URL", (Throwable)ex);
        }
    }

    protected void postProcessPersistenceUnitInfo(SpringPersistenceUnitInfo pui) {
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    @Override
    public String getPersistenceUnitName() {
        if (this.persistenceUnitInfo != null) {
            return this.persistenceUnitInfo.getPersistenceUnitName();
        }
        return super.getPersistenceUnitName();
    }
}

