/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.serversession;

import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.serversession.ListenerSessionManager;
import org.springframework.jms.listener.serversession.ServerSessionFactory;
import org.springframework.jms.listener.serversession.SimpleServerSessionFactory;
import org.springframework.jms.support.JmsUtils;

public class ServerSessionMessageListenerContainer
extends AbstractMessageListenerContainer
implements ListenerSessionManager {
    private ServerSessionFactory serverSessionFactory = new SimpleServerSessionFactory();
    private int maxMessagesPerTask = 1;
    private ConnectionConsumer consumer;

    public void setServerSessionFactory(ServerSessionFactory serverSessionFactory) {
        this.serverSessionFactory = serverSessionFactory != null ? serverSessionFactory : new SimpleServerSessionFactory();
    }

    protected ServerSessionFactory getServerSessionFactory() {
        return this.serverSessionFactory;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    protected int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    protected final boolean sharedConnectionEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerListener() throws JMSException {
        Connection con = this.getSharedConnection();
        Destination destination = this.getDestination();
        if (destination == null) {
            Session session = this.createSession(con);
            try {
                destination = this.resolveDestinationName(session, this.getDestinationName());
            }
            finally {
                JmsUtils.closeSession(session);
            }
        }
        ServerSessionPool pool = this.createServerSessionPool();
        this.consumer = this.createConsumer(con, destination, pool);
    }

    protected ServerSessionPool createServerSessionPool() throws JMSException {
        return new ServerSessionPool(){

            public ServerSession getServerSession() throws JMSException {
                ServerSessionMessageListenerContainer.this.logger.debug((Object)"JMS ConnectionConsumer requests ServerSession");
                return ServerSessionMessageListenerContainer.this.getServerSessionFactory().getServerSession(ServerSessionMessageListenerContainer.this);
            }
        };
    }

    protected final ConnectionConsumer getConsumer() {
        return this.consumer;
    }

    protected void destroyListener() throws JMSException {
        this.logger.debug((Object)"Closing ServerSessionFactory");
        this.getServerSessionFactory().close(this);
        this.logger.debug((Object)"Closing JMS ConnectionConsumer");
        this.consumer.close();
    }

    public Session createListenerSession() throws JMSException {
        final Session session = this.createSession(this.getSharedConnection());
        session.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                ServerSessionMessageListenerContainer.this.executeListener(session, message);
            }
        });
        return session;
    }

    public void executeListenerSession(Session session) {
        session.run();
    }

    protected ConnectionConsumer createConsumer(Connection con, Destination destination, ServerSessionPool pool) throws JMSException {
        if (this.getDurableSubscriptionName() != null && destination instanceof Topic) {
            return con.createDurableConnectionConsumer((Topic)destination, this.getDurableSubscriptionName(), this.getMessageSelector(), pool, this.getMaxMessagesPerTask());
        }
        return con.createConnectionConsumer(destination, this.getMessageSelector(), pool, this.getMaxMessagesPerTask());
    }
}

