/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.core.Constants;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.CachingDestinationResolver;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultMessageListenerContainer
extends AbstractMessageListenerContainer {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(class$org$springframework$jms$listener$DefaultMessageListenerContainer == null ? (class$org$springframework$jms$listener$DefaultMessageListenerContainer = DefaultMessageListenerContainer.class$("org.springframework.jms.listener.DefaultMessageListenerContainer")) : class$org$springframework$jms$listener$DefaultMessageListenerContainer) + "-";
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_CONNECTION = 1;
    public static final int CACHE_SESSION = 2;
    public static final int CACHE_CONSUMER = 3;
    private static final Constants constants = new Constants(class$org$springframework$jms$listener$DefaultMessageListenerContainer == null ? (class$org$springframework$jms$listener$DefaultMessageListenerContainer = DefaultMessageListenerContainer.class$("org.springframework.jms.listener.DefaultMessageListenerContainer")) : class$org$springframework$jms$listener$DefaultMessageListenerContainer);
    private final MessageListenerContainerResourceFactory transactionalResourceFactory = new MessageListenerContainerResourceFactory();
    private boolean pubSubNoLocal = false;
    private TaskExecutor taskExecutor;
    private int concurrentConsumers = 1;
    private int maxMessagesPerTask = Integer.MIN_VALUE;
    private PlatformTransactionManager transactionManager;
    private DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    private long receiveTimeout = 1000L;
    private long recoveryInterval = 5000L;
    private Integer cacheLevel;
    private Object currentRecoveryMarker = new Object();
    private final Object recoveryMonitor = new Object();
    private int activeInvokerCount = 0;
    private final Object activeInvokerMonitor = new Object();
    static /* synthetic */ Class class$org$springframework$jms$listener$DefaultMessageListenerContainer;

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    protected boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue(concurrentConsumers > 0, "concurrentConsumers must be positive");
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        Assert.isTrue(maxMessagesPerTask != 0, "maxMessagesPerTask must not be 0");
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionDefinition.setTimeout(transactionTimeout);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setCacheLevelName(String constantName) throws IllegalArgumentException {
        if (constantName == null || !constantName.startsWith("CACHE_")) {
            throw new IllegalArgumentException("Only cache constants allowed");
        }
        this.setCacheLevel(constants.asNumber(constantName).intValue());
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = new Integer(cacheLevel);
    }

    public int getCacheLevel() {
        return this.cacheLevel != null ? this.cacheLevel : 0;
    }

    public void afterPropertiesSet() {
        if (this.concurrentConsumers <= 0) {
            throw new IllegalArgumentException("concurrentConsumers value must be at least 1 (one)");
        }
        if (this.getDurableSubscriptionName() != null && this.concurrentConsumers != 1) {
            throw new IllegalArgumentException("Only 1 concurrent consumer supported for durable subscription");
        }
        super.afterPropertiesSet();
    }

    public void initialize() {
        if (this.transactionManager != null) {
            if (this.cacheLevel == null) {
                this.cacheLevel = new Integer(0);
            }
        } else if (this.cacheLevel == null) {
            this.cacheLevel = new Integer(3);
        }
        if (this.taskExecutor == null) {
            this.taskExecutor = new SimpleAsyncTaskExecutor(DEFAULT_THREAD_NAME_PREFIX);
        } else if (this.taskExecutor instanceof SchedulingTaskExecutor && ((SchedulingTaskExecutor)this.taskExecutor).prefersShortLivedTasks() && this.maxMessagesPerTask == Integer.MIN_VALUE) {
            this.maxMessagesPerTask = 1;
        }
        super.initialize();
    }

    protected final boolean sharedConnectionEnabled() {
        return this.getCacheLevel() >= 1;
    }

    protected void registerListener() throws JMSException {
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            this.taskExecutor.execute(new AsyncMessageListenerInvoker());
        }
    }

    protected void doRescheduleTask(Object task) {
        this.taskExecutor.execute((Runnable)task);
    }

    protected MessageConsumer createListenerConsumer(Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        return this.createConsumer(session, destination);
    }

    protected void receiveAndExecute(Session session, MessageConsumer consumer) throws JMSException {
        if (this.transactionManager != null) {
            TransactionStatus status = this.transactionManager.getTransaction(this.transactionDefinition);
            try {
                this.doReceiveAndExecute(session, consumer, status);
            }
            catch (JMSException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (Error err) {
                this.rollbackOnException(status, err);
                throw err;
            }
            this.transactionManager.commit(status);
        } else {
            this.doReceiveAndExecute(session, consumer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceiveAndExecute(Session session, MessageConsumer consumer, TransactionStatus status) throws JMSException {
        MessageConsumer consumerToClose;
        Session sessionToClose;
        Connection conToClose;
        block12: {
            conToClose = null;
            sessionToClose = null;
            consumerToClose = null;
            try {
                Message message;
                MessageConsumer consumerToUse;
                Session sessionToUse = session;
                boolean transactional = false;
                if (sessionToUse == null) {
                    sessionToUse = ConnectionFactoryUtils.doGetTransactionalSession(this.getConnectionFactory(), this.transactionalResourceFactory);
                    boolean bl = transactional = sessionToUse != null;
                }
                if (sessionToUse == null) {
                    Connection conToUse = null;
                    if (this.sharedConnectionEnabled()) {
                        conToUse = this.getSharedConnection();
                    } else {
                        conToClose = conToUse = this.createConnection();
                        conToUse.start();
                    }
                    sessionToClose = sessionToUse = this.createSession(conToUse);
                }
                if ((consumerToUse = consumer) == null) {
                    consumerToClose = consumerToUse = this.createListenerConsumer(sessionToUse);
                }
                if ((message = this.receiveMessage(consumerToUse)) == null) break block12;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received message of type [" + message.getClass() + "] from consumer [" + consumerToUse + "] of " + (transactional ? "transactional " : "") + "session [" + sessionToUse + "]"));
                }
                try {
                    this.doExecuteListener(sessionToUse, message);
                }
                catch (Throwable ex) {
                    if (status != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Rolling back transaction because of listener exception thrown: " + ex));
                        }
                        status.setRollbackOnly();
                    }
                    this.handleListenerException(ex);
                }
            }
            catch (Throwable throwable) {
                JmsUtils.closeMessageConsumer(consumerToClose);
                JmsUtils.closeSession(sessionToClose);
                JmsUtils.closeConnection(conToClose);
                throw throwable;
            }
        }
        JmsUtils.closeMessageConsumer(consumerToClose);
        JmsUtils.closeSession(sessionToClose);
        JmsUtils.closeConnection(conToClose);
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) {
        this.logger.debug((Object)"Initiating transaction rollback on application exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Application exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected Message receiveMessage(MessageConsumer consumer) throws JMSException {
        return this.receiveTimeout < 0L ? consumer.receive() : consumer.receive(this.receiveTimeout);
    }

    protected void establishSharedConnection() {
        this.refreshConnectionUntilSuccessful();
    }

    protected void startSharedConnection() {
        try {
            super.startSharedConnection();
        }
        catch (JMSException ex) {
            this.logger.debug((Object)"Connection start failed - relying on listeners to perform recovery", (Throwable)ex);
        }
    }

    protected void stopSharedConnection() {
        try {
            super.stopSharedConnection();
        }
        catch (JMSException ex) {
            this.logger.debug((Object)"Connection stop failed - relying on listeners to perform recovery after restart", (Throwable)ex);
        }
    }

    protected void handleListenerSetupFailure(Throwable ex, boolean alreadyRecovered) {
        if (ex instanceof JMSException) {
            this.invokeExceptionListener((JMSException)ex);
        }
        if (alreadyRecovered) {
            this.logger.debug((Object)"Setup of JMS message listener invoker failed - already recovered by other invoker", ex);
        } else {
            this.logger.error((Object)"Setup of JMS message listener invoker failed - trying to recover", ex);
        }
    }

    protected void recoverAfterListenerSetupFailure() {
        this.refreshConnectionUntilSuccessful();
        this.refreshDestination();
    }

    protected void refreshConnectionUntilSuccessful() {
        while (this.isActive()) {
            try {
                if (this.sharedConnectionEnabled()) {
                    this.refreshSharedConnection();
                    if (this.isRunning()) {
                        this.startSharedConnection();
                    }
                } else {
                    Connection con = this.createConnection();
                    JmsUtils.closeConnection(con);
                }
                this.logger.info((Object)"Successfully refreshed JMS Connection");
                break;
            }
            catch (JMSException ex) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Could not refresh JMS Connection - retrying in " + this.recoveryInterval + " ms"), (Throwable)ex);
                }
                if (this.recoveryInterval <= 0L) continue;
                try {
                    Thread.sleep(this.recoveryInterval);
                }
                catch (InterruptedException interEx) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected void refreshDestination() {
        DestinationResolver destResolver;
        String destName = this.getDestinationName();
        if (destName != null && (destResolver = this.getDestinationResolver()) instanceof CachingDestinationResolver) {
            ((CachingDestinationResolver)destResolver).removeFromCache(destName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyListener() throws JMSException {
        this.logger.debug((Object)"Waiting for shutdown of message listener invokers");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            while (this.activeInvokerCount > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Still waiting for shutdown of " + this.activeInvokerCount + " message listener invokers"));
                }
                try {
                    this.activeInvokerMonitor.wait();
                }
                catch (InterruptedException interEx) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected Connection getConnection(JmsResourceHolder holder) {
        return holder.getConnection();
    }

    protected Session getSession(JmsResourceHolder holder) {
        return holder.getSession();
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            if (this.getDurableSubscriptionName() != null) {
                return session.createDurableSubscriber((Topic)destination, this.getDurableSubscriptionName(), this.getMessageSelector(), this.isPubSubNoLocal());
            }
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MessageListenerContainerResourceFactory
    implements ConnectionFactoryUtils.ResourceFactory {
        private MessageListenerContainerResourceFactory() {
        }

        public Connection getConnection(JmsResourceHolder holder) {
            return DefaultMessageListenerContainer.this.getConnection(holder);
        }

        public Session getSession(JmsResourceHolder holder) {
            return DefaultMessageListenerContainer.this.getSession(holder);
        }

        public Connection createConnection() throws JMSException {
            if (DefaultMessageListenerContainer.this.sharedConnectionEnabled()) {
                return DefaultMessageListenerContainer.this.getSharedConnection();
            }
            return DefaultMessageListenerContainer.this.createConnection();
        }

        public Session createSession(Connection con) throws JMSException {
            return DefaultMessageListenerContainer.this.createSession(con);
        }
    }

    private class AsyncMessageListenerInvoker
    implements SchedulingAwareRunnable {
        private Session session;
        private MessageConsumer consumer;
        private Object lastRecoveryMarker;

        private AsyncMessageListenerInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block18: {
                Object object = DefaultMessageListenerContainer.this.activeInvokerMonitor;
                synchronized (object) {
                    DefaultMessageListenerContainer.this.activeInvokerCount++;
                    DefaultMessageListenerContainer.this.activeInvokerMonitor.notifyAll();
                }
                try {
                    if (DefaultMessageListenerContainer.this.maxMessagesPerTask < 0) {
                        while (DefaultMessageListenerContainer.this.isActive()) {
                            DefaultMessageListenerContainer.this.waitWhileNotRunning();
                            if (!DefaultMessageListenerContainer.this.isActive()) continue;
                            this.invokeListener();
                        }
                    } else {
                        for (int messageCount = 0; DefaultMessageListenerContainer.this.isRunning() && messageCount < DefaultMessageListenerContainer.this.maxMessagesPerTask; ++messageCount) {
                            this.invokeListener();
                        }
                    }
                }
                catch (Throwable ex) {
                    this.clearResources();
                    boolean alreadyRecovered = false;
                    Object object2 = DefaultMessageListenerContainer.this.recoveryMonitor;
                    synchronized (object2) {
                        if (this.lastRecoveryMarker == DefaultMessageListenerContainer.this.currentRecoveryMarker) {
                            DefaultMessageListenerContainer.this.handleListenerSetupFailure(ex, false);
                            DefaultMessageListenerContainer.this.recoverAfterListenerSetupFailure();
                            DefaultMessageListenerContainer.this.currentRecoveryMarker = new Object();
                        } else {
                            alreadyRecovered = true;
                        }
                    }
                    if (!alreadyRecovered) break block18;
                    DefaultMessageListenerContainer.this.handleListenerSetupFailure(ex, true);
                }
            }
            Object object = DefaultMessageListenerContainer.this.activeInvokerMonitor;
            synchronized (object) {
                DefaultMessageListenerContainer.this.activeInvokerCount--;
                DefaultMessageListenerContainer.this.activeInvokerMonitor.notifyAll();
            }
            if (!DefaultMessageListenerContainer.this.rescheduleTaskIfNecessary(this)) {
                this.clearResources();
            }
        }

        private void invokeListener() throws JMSException {
            this.initResourcesIfNecessary();
            DefaultMessageListenerContainer.this.receiveAndExecute(this.session, this.consumer);
        }

        private void initResourcesIfNecessary() throws JMSException {
            if (DefaultMessageListenerContainer.this.getCacheLevel() <= 1) {
                this.updateRecoveryMarker();
            } else {
                if (this.session == null && DefaultMessageListenerContainer.this.getCacheLevel() >= 2) {
                    this.updateRecoveryMarker();
                    this.session = DefaultMessageListenerContainer.this.createSession(DefaultMessageListenerContainer.this.getSharedConnection());
                }
                if (this.consumer == null && DefaultMessageListenerContainer.this.getCacheLevel() >= 3) {
                    this.consumer = DefaultMessageListenerContainer.this.createListenerConsumer(this.session);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRecoveryMarker() {
            Object object = DefaultMessageListenerContainer.this.recoveryMonitor;
            synchronized (object) {
                this.lastRecoveryMarker = DefaultMessageListenerContainer.this.currentRecoveryMarker;
            }
        }

        private void clearResources() {
            JmsUtils.closeMessageConsumer(this.consumer);
            JmsUtils.closeSession(this.session);
            this.consumer = null;
            this.session = null;
        }

        public boolean isLongLived() {
            return DefaultMessageListenerContainer.this.maxMessagesPerTask < 0;
        }
    }
}

