/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Session;
import org.springframework.jms.support.JmsUtils;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class JmsResourceHolder
extends ResourceHolderSupport {
    private final boolean frozen;
    private final List connections = new LinkedList();
    private final List sessions = new LinkedList();

    public JmsResourceHolder() {
        this.frozen = false;
    }

    public JmsResourceHolder(Connection connection, Session session) {
        this.addConnection(connection);
        this.addSession(session);
        this.frozen = true;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final void addConnection(Connection connection) {
        Assert.isTrue(!this.frozen, "Cannot add Connection because JmsResourceHolder is frozen");
        Assert.notNull(connection, "Connection must not be null");
        this.connections.add(connection);
    }

    public final void addSession(Session session) {
        Assert.isTrue(!this.frozen, "Cannot add Session because JmsResourceHolder is frozen");
        Assert.notNull(session, "Session must not be null");
        this.sessions.add(session);
    }

    public Connection getConnection() {
        return !this.connections.isEmpty() ? (Connection)this.connections.get(0) : null;
    }

    public Session getSession() {
        return !this.sessions.isEmpty() ? (Session)this.sessions.get(0) : null;
    }

    public Connection getConnection(Class connectionType) {
        return (Connection)CollectionUtils.findValueOfType((Collection)this.connections, connectionType);
    }

    public Session getSession(Class sessionType) {
        return (Session)CollectionUtils.findValueOfType((Collection)this.sessions, sessionType);
    }

    public void closeAll() {
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            JmsUtils.closeSession((Session)it.next());
        }
        it = this.connections.iterator();
        while (it.hasNext()) {
            JmsUtils.closeConnection((Connection)it.next());
        }
    }
}

