/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassArrayEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public ClassArrayEditor() {
        this(null);
    }

    public ClassArrayEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(text)) {
            String[] classNames = StringUtils.commaDelimitedListToStringArray(text);
            Class[] classes = new Class[classNames.length];
            for (int i = 0; i < classNames.length; ++i) {
                String className = classNames[i];
                try {
                    classes[i] = ClassUtils.forName(className.trim(), this.classLoader);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalArgumentException("Class not found: " + ex.getMessage());
                }
            }
            this.setValue(classes);
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        Object[] classes = (Class[])this.getValue();
        if (classes == null) {
            return "";
        }
        return StringUtils.arrayToCommaDelimitedString(classes);
    }
}

