/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.util.ObjectUtils;

public class PropertyAccessExceptionsException
extends BeansException {
    private PropertyAccessException[] propertyAccessExceptions;

    public PropertyAccessExceptionsException(PropertyAccessException[] propertyAccessExceptions) {
        super("");
        if (ObjectUtils.isEmpty(propertyAccessExceptions)) {
            throw new IllegalArgumentException("At least 1 PropertyAccessException required");
        }
        this.propertyAccessExceptions = propertyAccessExceptions;
    }

    public int getExceptionCount() {
        return this.propertyAccessExceptions.length;
    }

    public PropertyAccessException[] getPropertyAccessExceptions() {
        return this.propertyAccessExceptions;
    }

    public PropertyAccessException getPropertyAccessException(String propertyName) {
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            if (!propertyName.equals(pae.getPropertyChangeEvent().getPropertyName())) continue;
            return pae;
        }
        return null;
    }

    public String getMessage() {
        return "" + this.getExceptionCount() + " errors";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" (").append(this.getExceptionCount());
        sb.append(" errors); nested PropertyAccessExceptions are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            sb.append('\n').append("PropertyAccessException ").append(i + 1).append(": ");
            sb.append(this.propertyAccessExceptions[i]);
        }
        return sb.toString();
    }

    public void printStackTrace(PrintStream ps) {
        ps.println(this.getClass().getName() + " (" + this.getExceptionCount() + " errors); nested PropertyAccessException details are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            ps.println("PropertyAccessException " + (i + 1) + ":");
            this.propertyAccessExceptions[i].printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(this.getClass().getName() + " (" + this.getExceptionCount() + " errors); nested PropertyAccessException details are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            pw.println("PropertyAccessException " + (i + 1) + ":");
            this.propertyAccessExceptions[i].printStackTrace(pw);
        }
    }

    public boolean contains(Class exClass) {
        if (exClass == null) {
            return false;
        }
        if (exClass.isInstance(this)) {
            return true;
        }
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            if (!pae.contains(exClass)) continue;
            return true;
        }
        return false;
    }
}

