/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.AspectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionAwareMethodMatcher;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.core.OrderComparator;
import org.springframework.util.ClassUtils;

public abstract class AopUtils {
    private static Log logger = LogFactory.getLog((Class)(class$org$springframework$aop$support$AopUtils == null ? (class$org$springframework$aop$support$AopUtils = AopUtils.class$("org.springframework.aop.support.AopUtils")) : class$org$springframework$aop$support$AopUtils));
    static /* synthetic */ Class class$org$springframework$aop$support$AopUtils;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean isAopProxy(Object object) {
        return AopUtils.isJdkDynamicProxy(object) || AopUtils.isCglibProxy(object);
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass());
    }

    public static boolean isCglibProxy(Object object) {
        return object != null && AopUtils.isCglibProxyClass(object.getClass());
    }

    public static boolean isCglibProxyClass(Class clazz) {
        return clazz != null && clazz.getName().indexOf("$$") != -1;
    }

    public static boolean isEqualsMethod(Method method) {
        return method != null && method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == (class$java$lang$Object == null ? (class$java$lang$Object = AopUtils.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static Method getMostSpecificMethod(Method method, Class targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    public static String interfacesString(Collection interfaces) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Iterator itr = interfaces.iterator();
        while (itr.hasNext()) {
            Class intf = (Class)itr.next();
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(intf.getName());
        }
        return sb.toString();
    }

    public static boolean canApply(Pointcut pc, Class targetClass) {
        return AopUtils.canApply(pc, targetClass, false);
    }

    public static boolean canApply(Pointcut pc, Class targetClass, boolean hasIntroductions) {
        if (!pc.getClassFilter().matches(targetClass)) {
            return false;
        }
        MethodMatcher methodMatcher = pc.getMethodMatcher();
        IntroductionAwareMethodMatcher introductionAwareMethodMatcher = null;
        if (methodMatcher instanceof IntroductionAwareMethodMatcher) {
            introductionAwareMethodMatcher = (IntroductionAwareMethodMatcher)methodMatcher;
        }
        HashSet<Class> classes = new HashSet<Class>(ClassUtils.getAllInterfacesForClassAsSet(targetClass));
        classes.add(targetClass);
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            Method[] methods = clazz.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                if (!(introductionAwareMethodMatcher != null ? introductionAwareMethodMatcher.matches(methods[j], targetClass, hasIntroductions) : methodMatcher.matches(methods[j], targetClass))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canApply(Advisor advisor, Class targetClass) {
        return AopUtils.canApply(advisor, targetClass, false);
    }

    public static boolean canApply(Advisor advisor, Class targetClass, boolean hasIntroductions) {
        if (advisor instanceof IntroductionAdvisor) {
            return ((IntroductionAdvisor)advisor).getClassFilter().matches(targetClass);
        }
        if (advisor instanceof PointcutAdvisor) {
            PointcutAdvisor pca = (PointcutAdvisor)advisor;
            return AopUtils.canApply(pca.getPointcut(), targetClass, hasIntroductions);
        }
        return true;
    }

    public static List findAdvisorsThatCanApply(List candidateAdvisors, Class clazz) {
        List eligibleAdvisors = AopUtils.findIntroductionAdvisorsThatCanApply(candidateAdvisors, clazz);
        boolean hasIntroductions = !eligibleAdvisors.isEmpty();
        Iterator it = candidateAdvisors.iterator();
        while (it.hasNext()) {
            Advisor candidate = (Advisor)it.next();
            if (candidate instanceof IntroductionAdvisor) continue;
            if (AopUtils.canApply(candidate, clazz, hasIntroductions)) {
                eligibleAdvisors.add(candidate);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Candidate advisor [" + candidate + "] accepted for class [" + clazz.getName() + "]"));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Candidate advisor [" + candidate + "] rejected for class [" + clazz.getName() + "]"));
        }
        return eligibleAdvisors;
    }

    private static List findIntroductionAdvisorsThatCanApply(List candidateAdvisors, Class clazz) {
        LinkedList<Advisor> eligibleAdvisors = new LinkedList<Advisor>();
        Iterator it = candidateAdvisors.iterator();
        while (it.hasNext()) {
            Advisor candidate = (Advisor)it.next();
            if (candidate instanceof IntroductionAdvisor && AopUtils.canApply(candidate, clazz)) {
                eligibleAdvisors.add(candidate);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Candidate advisor [" + candidate + "] accepted for class [" + clazz.getName() + "]"));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Candidate advisor [" + candidate + "] rejected for class [" + clazz.getName() + "]"));
        }
        return eligibleAdvisors;
    }

    public static List sortAdvisorsByOrder(List advisors) {
        Collections.sort(advisors, new OrderComparator());
        return advisors;
    }

    public static Object invokeJoinpointUsingReflection(Object target, Method method, Object[] args) throws Throwable {
        try {
            method.setAccessible(true);
            Object object = method.invoke(target, args);
            return object;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalArgumentException ex) {
            throw new AspectException("AOP configuration seems to be invalid: tried calling method [" + method + "] on target [" + target + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new AspectException("Couldn't access method: " + method, ex);
        }
        finally {
            method.setAccessible(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

