/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AopNamespaceUtils {
    public static final String AUTO_PROXY_CREATOR_BEAN_NAME = "org.springframework.aop.config.internalAutoProxyCreator";
    public static final String ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME = "org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator";
    private static final List APC_PRIORITY_LIST = new ArrayList();
    static /* synthetic */ Class class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator;

    public static void registerAutoProxyCreatorIfNecessary(ParserContext parserContext) {
        AopNamespaceUtils.registryOrEscalateApcAsRequired(class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator = AopNamespaceUtils.class$("org.springframework.aop.framework.autoproxy.InvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator, parserContext);
    }

    public static void registerAspectJAutoProxyCreatorIfNecessary(ParserContext parserContext) {
        AopNamespaceUtils.registryOrEscalateApcAsRequired(class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator = AopNamespaceUtils.class$("org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator, parserContext);
    }

    public static void registerAtAspectJAutoProxyCreatorIfNecessary(ParserContext parserContext) {
        Class cls = AopNamespaceUtils.getAspectJAutoProxyCreatorClassIfPossible();
        if (cls == null) {
            throw new IllegalStateException("Unable to register AspectJ AutoProxyCreator. Cannot find class [org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator]. Are you running on Java 5.0+?");
        }
        AopNamespaceUtils.registryOrEscalateApcAsRequired(cls, parserContext);
    }

    private static void registryOrEscalateApcAsRequired(Class cls, ParserContext parserContext) {
        Assert.notNull(cls, "Class cannot be null");
        Assert.notNull(parserContext, "ParserContext cannot be null");
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            int requiredPriority;
            AbstractBeanDefinition abd = (AbstractBeanDefinition)registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            if (cls.equals(abd.getBeanClass())) {
                return;
            }
            int currentPriority = AopNamespaceUtils.findPriorityForClass(abd.getBeanClass().getName());
            if (currentPriority < (requiredPriority = AopNamespaceUtils.findPriorityForClass(cls.getName()))) {
                abd.setBeanClass(cls);
            }
        } else {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(cls);
            beanDefinition.setRole(2);
            registry.registerBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME, beanDefinition);
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition(beanDefinition, AUTO_PROXY_CREATOR_BEAN_NAME);
            parserContext.getReaderContext().fireComponentRegistered(componentDefinition);
        }
    }

    public static void forceAutoProxyCreatorToUseClassProxying(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            BeanDefinition definition = registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            definition.getPropertyValues().addPropertyValue("proxyTargetClass", Boolean.TRUE);
        }
    }

    private static Class getAspectJAutoProxyCreatorClassIfPossible() {
        try {
            return ClassUtils.forName(ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private static final int findPriorityForClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        for (int i = 0; i < APC_PRIORITY_LIST.size(); ++i) {
            String str = (String)APC_PRIORITY_LIST.get(i);
            if (!className.equals(str)) continue;
            return i;
        }
        throw new IllegalArgumentException("Class name [" + className + "] is not a known auto-proxy creator class");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        APC_PRIORITY_LIST.add((class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator = AopNamespaceUtils.class$("org.springframework.aop.framework.autoproxy.InvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator).getName());
        APC_PRIORITY_LIST.add((class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator = AopNamespaceUtils.class$("org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator).getName());
        APC_PRIORITY_LIST.add(ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
    }
}

