/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.lang.reflect.SourceLocation;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.aop.framework.ReflectiveMethodInvocation;

public class MethodInvocationProceedingJoinPoint
implements ProceedingJoinPoint,
JoinPoint.StaticPart {
    private final MethodInvocation methodInvocation;
    private Object[] defensiveCopyOfArgs;
    private Signature signature;
    private SourceLocation sourceLocation;

    public MethodInvocationProceedingJoinPoint(MethodInvocation methodInvocation) {
        this.methodInvocation = methodInvocation;
    }

    public void set$AroundClosure(AroundClosure aroundClosure) {
        throw new UnsupportedOperationException();
    }

    public Object proceed() throws Throwable {
        return this.methodInvocation.proceed();
    }

    public Object proceed(Object[] args) throws Throwable {
        Object[] oldArgs = this.methodInvocation.getArguments();
        for (int i = 0; i < oldArgs.length; ++i) {
            oldArgs[i] = args[i];
        }
        return this.methodInvocation.proceed();
    }

    public String toShortString() {
        return "execution(" + this.methodInvocation.getMethod().getName() + ")";
    }

    public String toLongString() {
        return this.getClass().getName() + ": execution: [" + this.methodInvocation + "]";
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.toShortString();
    }

    public Object getThis() {
        return ((ReflectiveMethodInvocation)this.methodInvocation).getProxy();
    }

    public Object getTarget() {
        return this.methodInvocation.getThis();
    }

    public Object[] getArgs() {
        if (this.defensiveCopyOfArgs == null) {
            Object[] argsSource = this.methodInvocation.getArguments();
            this.defensiveCopyOfArgs = new Object[argsSource.length];
            System.arraycopy(argsSource, 0, this.defensiveCopyOfArgs, 0, argsSource.length);
        }
        return this.defensiveCopyOfArgs;
    }

    public synchronized Signature getSignature() {
        if (this.signature == null) {
            this.signature = new MethodSignatureImpl();
        }
        return this.signature;
    }

    public synchronized SourceLocation getSourceLocation() {
        if (this.sourceLocation == null) {
            this.sourceLocation = new SourceLocationImpl();
        }
        return this.sourceLocation;
    }

    public String getKind() {
        return "method-execution";
    }

    public JoinPoint.StaticPart getStaticPart() {
        return this;
    }

    private class SourceLocationImpl
    implements SourceLocation {
        private SourceLocationImpl() {
        }

        public Class getWithinType() {
            if (MethodInvocationProceedingJoinPoint.this.methodInvocation.getThis() == null) {
                throw new UnsupportedOperationException("No source location joinpoint available: target is null");
            }
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getThis().getClass();
        }

        public String getFileName() {
            throw new UnsupportedOperationException();
        }

        public int getLine() {
            throw new UnsupportedOperationException();
        }

        public int getColumn() {
            throw new UnsupportedOperationException();
        }
    }

    private class MethodSignatureImpl
    implements Signature,
    MethodSignature {
        private MethodSignatureImpl() {
        }

        public String toShortString() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getName();
        }

        public String toLongString() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().toString();
        }

        public String getName() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getName();
        }

        public int getModifiers() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getModifiers();
        }

        public Class getDeclaringType() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getDeclaringClass();
        }

        public String getDeclaringTypeName() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getDeclaringClass().getName();
        }

        public Class getReturnType() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getReturnType();
        }

        public Method getMethod() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod();
        }

        public Class[] getParameterTypes() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getParameterTypes();
        }

        public String[] getParameterNames() {
            throw new UnsupportedOperationException("Parameter names cannot be determined unless compiled by AspectJ compiler");
        }

        public Class[] getExceptionTypes() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getExceptionTypes();
        }
    }
}

