/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.core.io.ResourceEditor;
import org.springframework.util.StringUtils;
import org.springframework.web.portlet.context.PortletContextResourceLoader;

public abstract class PortletBean
extends GenericPortlet {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Set requiredProperties = new HashSet();
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init() throws PortletException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initializing portlet '" + this.getPortletName() + "'"));
        }
        try {
            PortletConfigPropertyValues pvs = new PortletConfigPropertyValues(this.getPortletConfig(), this.requiredProperties);
            BeanWrapperImpl bw = new BeanWrapperImpl((Object)this);
            PortletContextResourceLoader resourceLoader = new PortletContextResourceLoader(this.getPortletContext());
            bw.registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = PortletBean.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, new ResourceEditor(resourceLoader));
            this.initBeanWrapper(bw);
            bw.setPropertyValues(pvs, true);
        }
        catch (BeansException ex) {
            this.logger.error((Object)("Failed to set bean properties on portlet '" + this.getPortletName() + "'"), (Throwable)ex);
            throw ex;
        }
        this.initPortletBean();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Portlet '" + this.getPortletName() + "' configured successfully"));
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    protected void initPortletBean() throws PortletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PortletConfigPropertyValues
    extends MutablePropertyValues {
        private PortletConfigPropertyValues(PortletConfig config, Set requiredProperties) throws PortletException {
            HashSet missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet(requiredProperties) : null;
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new PortletException("Initialization from PortletConfig for portlet '" + config.getPortletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, ", "));
            }
        }
    }
}

