/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.HeuristicCompletionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSuspensionNotSupportedException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.jta.JtaTransactionObject;
import org.springframework.transaction.jta.UserTransactionAdapter;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class JtaTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean,
Serializable {
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static final String[] FALLBACK_TRANSACTION_MANAGER_NAMES = new String[]{"java:comp/TransactionManager", "java:pm/TransactionManager", "java:/TransactionManager"};
    private transient JndiTemplate jndiTemplate = new JndiTemplate();
    private transient UserTransaction userTransaction;
    private String userTransactionName = "java:comp/UserTransaction";
    private boolean cacheUserTransaction = true;
    private transient TransactionManager transactionManager;
    private String transactionManagerName;
    private boolean autodetectTransactionManager = true;
    static /* synthetic */ Class class$javax$transaction$UserTransaction;
    static /* synthetic */ Class class$javax$transaction$TransactionManager;

    public JtaTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public JtaTransactionManager(UserTransaction userTransaction) {
        this();
        this.userTransaction = userTransaction;
        this.afterPropertiesSet();
    }

    public JtaTransactionManager(UserTransaction userTransaction, TransactionManager transactionManager) {
        this();
        this.userTransaction = userTransaction;
        this.transactionManager = transactionManager;
        this.afterPropertiesSet();
    }

    public JtaTransactionManager(TransactionManager transactionManager) {
        this();
        this.userTransactionName = null;
        this.transactionManager = transactionManager;
        this.afterPropertiesSet();
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        if (jndiTemplate == null) {
            throw new IllegalArgumentException("jndiTemplate must not be null");
        }
        this.jndiTemplate = jndiTemplate;
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiTemplate = new JndiTemplate(jndiEnvironment);
    }

    public Properties getJndiEnvironment() {
        return this.jndiTemplate.getEnvironment();
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public void setUserTransactionName(String userTransactionName) {
        this.userTransactionName = userTransactionName;
    }

    public void setCacheUserTransaction(boolean cacheUserTransaction) {
        this.cacheUserTransaction = cacheUserTransaction;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
    }

    public void setAutodetectTransactionManager(boolean autodetectTransactionManager) {
        this.autodetectTransactionManager = autodetectTransactionManager;
    }

    public void afterPropertiesSet() throws TransactionSystemException {
        if (this.userTransaction == null) {
            this.userTransaction = this.userTransactionName != null ? this.lookupUserTransaction(this.userTransactionName) : this.retrieveUserTransaction();
        }
        if (this.transactionManager == null) {
            this.transactionManager = this.transactionManagerName != null ? this.lookupTransactionManager(this.transactionManagerName) : this.retrieveTransactionManager();
        }
        if (this.transactionManager == null && this.autodetectTransactionManager) {
            this.transactionManager = this.findTransactionManager(this.userTransaction);
        }
        if (this.userTransaction == null && this.transactionManager != null) {
            this.userTransaction = this.transactionManager instanceof UserTransaction ? (UserTransaction)this.transactionManager : new UserTransactionAdapter(this.transactionManager);
        }
        if (this.userTransaction != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using JTA UserTransaction: " + this.userTransaction));
            }
        } else {
            throw new IllegalArgumentException("Either 'userTransaction' or 'userTransactionName' or 'transactionManager' or 'transactionManagerName' must be set");
        }
        if (this.transactionManager != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using JTA TransactionManager: " + this.transactionManager));
            }
        } else {
            this.logger.warn((Object)"No JTA TransactionManager found: transaction suspension and synchronization with existing JTA transactions not available");
        }
    }

    protected UserTransaction lookupUserTransaction(String userTransactionName) throws TransactionSystemException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving JTA UserTransaction from JNDI location [" + userTransactionName + "]"));
            }
            UserTransaction ut = (UserTransaction)this.getJndiTemplate().lookup(userTransactionName, class$javax$transaction$UserTransaction == null ? (class$javax$transaction$UserTransaction = JtaTransactionManager.class$("javax.transaction.UserTransaction")) : class$javax$transaction$UserTransaction);
            return ut;
        }
        catch (NamingException ex) {
            throw new TransactionSystemException("JTA UserTransaction is not available at JNDI location [" + userTransactionName + "]", ex);
        }
    }

    protected TransactionManager lookupTransactionManager(String transactionManagerName) throws TransactionSystemException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving JTA TransactionManager from JNDI location [" + transactionManagerName + "]"));
            }
            TransactionManager tm = (TransactionManager)this.getJndiTemplate().lookup(transactionManagerName, class$javax$transaction$TransactionManager == null ? (class$javax$transaction$TransactionManager = JtaTransactionManager.class$("javax.transaction.TransactionManager")) : class$javax$transaction$TransactionManager);
            return tm;
        }
        catch (NamingException ex) {
            throw new TransactionSystemException("JTA TransactionManager is not available at JNDI location [" + transactionManagerName + "]", ex);
        }
    }

    protected UserTransaction retrieveUserTransaction() throws TransactionSystemException {
        return null;
    }

    protected TransactionManager retrieveTransactionManager() throws TransactionSystemException {
        return null;
    }

    protected TransactionManager findTransactionManager(UserTransaction ut) {
        if (ut instanceof TransactionManager) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("JTA UserTransaction object [" + ut + "] implements TransactionManager"));
            }
            return (TransactionManager)ut;
        }
        for (int i = 0; i < FALLBACK_TRANSACTION_MANAGER_NAMES.length; ++i) {
            String jndiName = FALLBACK_TRANSACTION_MANAGER_NAMES[i];
            try {
                TransactionManager tm = this.lookupTransactionManager(jndiName);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("JTA TransactionManager found at fallback JNDI location [" + jndiName + "]"));
                }
                return tm;
            }
            catch (TransactionSystemException ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("No JTA TransactionManager found at fallback JNDI location [" + jndiName + "]"), (Throwable)ex);
                continue;
            }
        }
        return null;
    }

    protected Object doGetTransaction() {
        UserTransaction ut = this.getUserTransaction();
        if (!this.cacheUserTransaction && this.userTransactionName != null) {
            ut = this.lookupUserTransaction(this.userTransactionName);
        }
        return this.doGetJtaTransaction(ut);
    }

    protected JtaTransactionObject doGetJtaTransaction(UserTransaction ut) {
        return new JtaTransactionObject(ut);
    }

    protected boolean isExistingTransaction(Object transaction) {
        JtaTransactionObject txObject = (JtaTransactionObject)transaction;
        try {
            return txObject.getUserTransaction().getStatus() != 6;
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on getStatus", ex);
        }
    }

    protected boolean useSavepointForNestedTransaction() {
        return false;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        JtaTransactionObject txObject = (JtaTransactionObject)transaction;
        try {
            this.doJtaBegin(txObject, definition);
        }
        catch (NotSupportedException ex) {
            throw new NestedTransactionNotSupportedException("JTA implementation does not support nested transactions", ex);
        }
        catch (UnsupportedOperationException ex) {
            throw new NestedTransactionNotSupportedException("JTA implementation does not support nested transactions", ex);
        }
        catch (SystemException ex) {
            throw new CannotCreateTransactionException("JTA failure on begin", ex);
        }
    }

    protected void doJtaBegin(JtaTransactionObject txObject, TransactionDefinition definition) throws NotSupportedException, SystemException {
        this.applyIsolationLevel(txObject, definition.getIsolationLevel());
        this.applyTimeout(txObject, definition.getTimeout());
        txObject.getUserTransaction().begin();
    }

    protected void applyIsolationLevel(JtaTransactionObject txObject, int isolationLevel) throws InvalidIsolationLevelException, SystemException {
        if (isolationLevel != -1) {
            throw new InvalidIsolationLevelException("JtaTransactionManager does not support custom isolation levels");
        }
    }

    protected void applyTimeout(JtaTransactionObject txObject, int timeout) throws SystemException {
        if (timeout > -1) {
            txObject.getUserTransaction().setTransactionTimeout(timeout);
        }
    }

    protected Object doSuspend(Object transaction) {
        JtaTransactionObject txObject = (JtaTransactionObject)transaction;
        try {
            return this.doJtaSuspend(txObject);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on suspend", ex);
        }
    }

    protected Object doJtaSuspend(JtaTransactionObject txObject) throws SystemException {
        if (this.getTransactionManager() == null) {
            throw new TransactionSuspensionNotSupportedException("JtaTransactionManager needs a JTA TransactionManager for suspending a transaction: specify the 'transactionManager' or 'transactionManagerName' property");
        }
        return this.getTransactionManager().suspend();
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        JtaTransactionObject txObject = (JtaTransactionObject)transaction;
        try {
            this.doJtaResume(txObject, suspendedResources);
        }
        catch (InvalidTransactionException ex) {
            throw new IllegalTransactionStateException("Tried to resume invalid JTA transaction", ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on resume", ex);
        }
    }

    protected void doJtaResume(JtaTransactionObject txObject, Object suspendedTransaction) throws InvalidTransactionException, SystemException {
        if (this.getTransactionManager() == null) {
            throw new TransactionSuspensionNotSupportedException("JtaTransactionManager needs a JTA TransactionManager for suspending a transaction: specify the 'transactionManager' or 'transactionManagerName' property");
        }
        this.getTransactionManager().resume((Transaction)suspendedTransaction);
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return true;
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JtaTransactionObject txObject = (JtaTransactionObject)status.getTransaction();
        try {
            txObject.getUserTransaction().commit();
        }
        catch (RollbackException ex) {
            throw new UnexpectedRollbackException("JTA transaction unexpectedly rolled back (maybe due to a timeout)", ex);
        }
        catch (HeuristicMixedException ex) {
            throw new HeuristicCompletionException(3, (Throwable)ex);
        }
        catch (HeuristicRollbackException ex) {
            throw new HeuristicCompletionException(2, (Throwable)ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on commit", ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JtaTransactionObject txObject = (JtaTransactionObject)status.getTransaction();
        try {
            if (txObject.getUserTransaction().getStatus() != 6) {
                txObject.getUserTransaction().rollback();
            }
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on rollback", ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JtaTransactionObject txObject = (JtaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)"Setting JTA transaction rollback-only");
        }
        try {
            if (txObject.getUserTransaction().getStatus() != 6) {
                txObject.getUserTransaction().setRollbackOnly();
            }
        }
        catch (IllegalStateException ex) {
            throw new NoTransactionException("No active JTA transaction");
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on setRollbackOnly", ex);
        }
    }

    protected void registerAfterCompletionWithExistingTransaction(Object transaction, List synchronizations) {
        JtaTransactionObject txObject = (JtaTransactionObject)transaction;
        this.logger.debug((Object)"Registering after-completion synchronization with existing JTA transaction");
        try {
            this.doRegisterAfterCompletionWithJtaTransaction(txObject, synchronizations);
        }
        catch (RollbackException ex) {
            this.logger.debug((Object)"Participating in existing JTA transaction that has been marked rollback-only: cannot register Spring after-completion callbacks with outer JTA transaction - immediately performing Spring after-completion callbacks with outcome status 'rollback'");
            this.invokeAfterCompletion(synchronizations, 1);
        }
        catch (IllegalStateException ex) {
            throw new NoTransactionException("No active JTA transaction");
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on registerSynchronization", ex);
        }
    }

    protected void doRegisterAfterCompletionWithJtaTransaction(JtaTransactionObject txObject, List synchronizations) throws RollbackException, SystemException {
        if (this.getTransactionManager() != null) {
            this.getTransactionManager().getTransaction().registerSynchronization((Synchronization)new JtaAfterCompletionSynchronization(synchronizations));
        } else {
            this.logger.warn((Object)"Participating in existing JTA transaction, but no JTA TransactionManager available: cannot register Spring after-completion callbacks with outer JTA transaction - performing Spring after-completion callbacks with outcome status 'unknown'");
            this.invokeAfterCompletion(synchronizations, 2);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.jndiTemplate = new JndiTemplate();
        if (this.userTransactionName != null) {
            this.userTransaction = this.lookupUserTransaction(this.userTransactionName);
        }
        if (this.transactionManagerName != null) {
            this.transactionManager = this.lookupTransactionManager(this.transactionManagerName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JtaAfterCompletionSynchronization
    implements Synchronization {
        private final List synchronizations;

        public JtaAfterCompletionSynchronization(List synchronizations) {
            this.synchronizations = synchronizations;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 3: {
                    JtaTransactionManager.this.invokeAfterCompletion(this.synchronizations, 0);
                    break;
                }
                case 4: {
                    JtaTransactionManager.this.invokeAfterCompletion(this.synchronizations, 1);
                    break;
                }
                default: {
                    JtaTransactionManager.this.invokeAfterCompletion(this.synchronizations, 2);
                }
            }
        }
    }
}

