/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.instrument.classloading.AbstractLoadTimeWeaver;
import org.springframework.util.ReflectionUtils;

public class ReflectiveLoadTimeWeaver
extends AbstractLoadTimeWeaver {
    protected String METHOD_NAME_ADD_TRANSFORMERS = "addTransformer";
    protected String METHOD_NAME_THROWAWAY_CLASSLOADER = "getThrowawayClassLoader";
    private final ClassLoader classLoader;

    public ReflectiveLoadTimeWeaver() {
        this.classLoader = this.getContextClassLoader();
    }

    public ReflectiveLoadTimeWeaver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.invokeMethod(this.METHOD_NAME_ADD_TRANSFORMERS, new Object[]{transformer}, ClassFileTransformer.class);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return (ClassLoader)this.invokeMethod(this.METHOD_NAME_THROWAWAY_CLASSLOADER, null, null);
    }

    private Object invokeMethod(String methodName, Object[] args, Class ... argumentTypes) {
        return ReflectionUtils.invokeMethod(methodName, this.classLoader.getClass(), this.classLoader, args, argumentTypes);
    }
}

