/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSingletonBeanRegistry
implements SingletonBeanRegistry {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map singletonCache = new HashMap();
    private final Set singletonsCurrentlyInCreation = Collections.synchronizedSet(new HashSet());
    private final Map disposableBeans = CollectionFactory.createLinkedMapIfPossible(16);
    private final Map dependentBeanMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSingleton(String beanName, Object sharedBean) throws IllegalStateException {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(sharedBean, "Singleton object must not be null");
        Map map = this.singletonCache;
        synchronized (map) {
            Object oldObject = this.singletonCache.get(beanName);
            if (oldObject != null) {
                throw new IllegalStateException("Could not register object [" + sharedBean + "] under bean name '" + beanName + "': there's already object [" + oldObject + " bound");
            }
            this.addSingleton(beanName, sharedBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSingleton(String beanName, Object sharedBean) {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(sharedBean, "Singleton object must not be null");
        Map map = this.singletonCache;
        synchronized (map) {
            this.singletonCache.put(beanName, sharedBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingleton(String beanName) {
        Map map = this.singletonCache;
        synchronized (map) {
            return this.singletonCache.get(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingleton(String beanName, ObjectFactory singletonFactory) {
        Map map = this.singletonCache;
        synchronized (map) {
            Object sharedInstance = this.singletonCache.get(beanName);
            if (sharedInstance == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating shared instance of singleton bean '" + beanName + "'"));
                }
                try {
                    this.beforeSingletonCreation(beanName);
                    sharedInstance = singletonFactory.getObject();
                }
                finally {
                    this.afterSingletonCreation(beanName);
                }
                this.addSingleton(beanName, sharedInstance);
            }
            return sharedInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSingleton(String beanName) {
        Assert.hasText(beanName, "Bean name must not be empty");
        Map map = this.singletonCache;
        synchronized (map) {
            this.singletonCache.remove(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSingleton(String beanName) {
        Assert.hasText(beanName, "Bean name must not be empty");
        Map map = this.singletonCache;
        synchronized (map) {
            return this.singletonCache.containsKey(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSingletonNames() {
        Map map = this.singletonCache;
        synchronized (map) {
            return StringUtils.toStringArray(this.singletonCache.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSingletonCount() {
        Map map = this.singletonCache;
        synchronized (map) {
            return this.singletonCache.size();
        }
    }

    protected void beforeSingletonCreation(String beanName) {
        this.singletonsCurrentlyInCreation.add(beanName);
    }

    protected void afterSingletonCreation(String beanName) {
        this.singletonsCurrentlyInCreation.remove(beanName);
    }

    public final boolean isSingletonCurrentlyInCreation(String beanName) {
        return this.singletonsCurrentlyInCreation.contains(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisposableBean(String beanName, DisposableBean bean) {
        Map map = this.disposableBeans;
        synchronized (map) {
            this.disposableBeans.put(beanName, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependentBean(String beanName, String dependentBeanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            Set dependencies = (Set)this.dependentBeanMap.get(beanName);
            if (dependencies == null) {
                dependencies = CollectionFactory.createLinkedSetIfPossible(8);
                this.dependentBeanMap.put(beanName, dependencies);
            }
            dependencies.add(dependentBeanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasDependentBean(String beanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            return this.dependentBeanMap.containsKey(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Destroying singletons in {" + this + "}"));
        }
        Map map = this.singletonCache;
        synchronized (map) {
            Map map2 = this.disposableBeans;
            synchronized (map2) {
                String[] disposableBeanNames = StringUtils.toStringArray(this.disposableBeans.keySet());
                for (int i = disposableBeanNames.length - 1; i >= 0; --i) {
                    this.destroySingleton(disposableBeanNames[i]);
                }
            }
            this.singletonCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingleton(String beanName) {
        this.removeSingleton(beanName);
        DisposableBean disposableBean = null;
        Map map = this.disposableBeans;
        synchronized (map) {
            disposableBean = (DisposableBean)this.disposableBeans.remove(beanName);
        }
        this.destroyBean(beanName, disposableBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyBean(String beanName, DisposableBean bean) {
        Set dependencies = null;
        Map map = this.dependentBeanMap;
        synchronized (map) {
            dependencies = (Set)this.dependentBeanMap.remove(beanName);
        }
        if (dependencies != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved dependent beans for bean '" + beanName + "': " + dependencies));
            }
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                String dependentBeanName = (String)it.next();
                this.destroySingleton(dependentBeanName);
            }
        }
        if (bean != null) {
            try {
                bean.destroy();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Destroy method on bean with name '" + beanName + "' threw an exception"), ex);
            }
        }
    }
}

