/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.portlet.PortletContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.portlet.util.PortletUtils;

public class PortletContextResource
extends AbstractResource {
    private final PortletContext portletContext;
    private final String path;

    public PortletContextResource(PortletContext portletContext, String path) {
        Assert.notNull(portletContext, "Cannot resolve PortletContextResource without PortletContext");
        this.portletContext = portletContext;
        Assert.notNull(path, "path is required");
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public String getPath() {
        return this.path;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.portletContext.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return is;
    }

    public URL getURL() throws IOException {
        URL url = this.portletContext.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    public File getFile() throws IOException {
        String realPath = PortletUtils.getRealPath(this.portletContext, this.path);
        return new File(realPath);
    }

    public Resource createRelative(String relativePath) throws IOException {
        String pathToUse = StringUtils.applyRelativePath(this.path, relativePath);
        return new PortletContextResource(this.portletContext, pathToUse);
    }

    public String getFilename() {
        return StringUtils.getFilename(this.path);
    }

    public String getDescription() {
        return "PortletContext resource [" + this.path + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PortletContextResource) {
            PortletContextResource otherRes = (PortletContextResource)obj;
            return this.portletContext.equals(otherRes.portletContext) && this.path.equals(otherRes.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

