/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ObjectError;

public abstract class AbstractBindingResult
implements BindingResult,
Serializable {
    private final List errors = new LinkedList();
    private final String objectName;
    private MessageCodesResolver messageCodesResolver = new DefaultMessageCodesResolver();
    private String nestedPath = "";
    private final Stack nestedPathStack = new Stack();
    private Set suppressedFields = new HashSet();

    protected AbstractBindingResult(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public void setNestedPath(String nestedPath) {
        this.doSetNestedPath(nestedPath);
        this.nestedPathStack.clear();
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public void pushNestedPath(String subPath) {
        this.nestedPathStack.push(this.getNestedPath());
        this.doSetNestedPath(this.getNestedPath() + subPath);
    }

    public void popNestedPath() throws IllegalArgumentException {
        try {
            String formerNestedPath = (String)this.nestedPathStack.pop();
            this.doSetNestedPath(formerNestedPath);
        }
        catch (EmptyStackException ex) {
            throw new IllegalStateException("Cannot pop nested path: no nested path on stack");
        }
    }

    protected void doSetNestedPath(String nestedPath) {
        if (nestedPath == null) {
            nestedPath = "";
        }
        if ((nestedPath = this.canonicalFieldName(nestedPath)).length() > 0 && !nestedPath.endsWith(".")) {
            nestedPath = nestedPath + ".";
        }
        this.nestedPath = nestedPath;
    }

    protected String fixedField(String field) {
        return this.getNestedPath() + this.canonicalFieldName(field);
    }

    public void reject(String errorCode) {
        this.reject(errorCode, null, null);
    }

    public void reject(String errorCode, String defaultMessage) {
        this.reject(errorCode, null, defaultMessage);
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.addError(new ObjectError(this.getObjectName(), this.resolveMessageCodes(errorCode), errorArgs, defaultMessage));
    }

    public void rejectValue(String field, String errorCode) {
        this.rejectValue(field, errorCode, null, null);
    }

    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.rejectValue(field, errorCode, null, defaultMessage);
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        String fixedField = this.fixedField(field);
        Object newVal = this.getActualFieldValue(fixedField);
        FieldError fe = new FieldError(this.getObjectName(), fixedField, newVal, false, this.resolveMessageCodes(errorCode, field), errorArgs, defaultMessage);
        this.addError(fe);
    }

    public String[] resolveMessageCodes(String errorCode) {
        return this.getMessageCodesResolver().resolveMessageCodes(errorCode, this.getObjectName());
    }

    public String[] resolveMessageCodes(String errorCode, String field) {
        String fixedField = this.fixedField(field);
        Class fieldType = this.getFieldType(fixedField);
        return this.getMessageCodesResolver().resolveMessageCodes(errorCode, this.getObjectName(), fixedField, fieldType);
    }

    public void addError(ObjectError error) {
        this.errors.add(error);
    }

    public void addAllErrors(Errors errors) {
        this.errors.addAll(errors.getAllErrors());
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public List getAllErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean hasGlobalErrors() {
        return this.getGlobalErrorCount() > 0;
    }

    public int getGlobalErrorCount() {
        return this.getGlobalErrors().size();
    }

    public List getGlobalErrors() {
        LinkedList result = new LinkedList();
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (error instanceof FieldError) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public ObjectError getGlobalError() {
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            ObjectError objectError = (ObjectError)it.next();
            if (objectError instanceof FieldError) continue;
            return objectError;
        }
        return null;
    }

    public boolean hasFieldErrors() {
        return this.getFieldErrorCount() > 0;
    }

    public int getFieldErrorCount() {
        return this.getFieldErrors().size();
    }

    public List getFieldErrors() {
        LinkedList result = new LinkedList();
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (!(error instanceof FieldError)) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public FieldError getFieldError() {
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (!(error instanceof FieldError)) continue;
            return (FieldError)error;
        }
        return null;
    }

    public boolean hasFieldErrors(String field) {
        return this.getFieldErrorCount(field) > 0;
    }

    public int getFieldErrorCount(String field) {
        return this.getFieldErrors(field).size();
    }

    public List getFieldErrors(String field) {
        LinkedList result = new LinkedList();
        String fixedField = this.fixedField(field);
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (!(error instanceof FieldError) || !this.isMatchingFieldError(fixedField, (FieldError)error)) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public FieldError getFieldError(String field) {
        String fixedField = this.fixedField(field);
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            FieldError fe;
            Object error = it.next();
            if (!(error instanceof FieldError) || !this.isMatchingFieldError(fixedField, fe = (FieldError)error)) continue;
            return fe;
        }
        return null;
    }

    protected boolean isMatchingFieldError(String field, FieldError fieldError) {
        return field.equals(fieldError.getField()) || field.endsWith("*") && fieldError.getField().startsWith(field.substring(0, field.length() - 1));
    }

    public Object getFieldValue(String field) {
        FieldError fe = this.getFieldError(field);
        Object value = null;
        value = fe != null ? fe.getRejectedValue() : this.getActualFieldValue(this.fixedField(field));
        if (fe == null || !fe.isBindingFailure()) {
            value = this.formatFieldValue(field, value);
        }
        return value;
    }

    public Map getModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_KEY_PREFIX + this.getObjectName(), this);
        model.put(this.getObjectName(), this.getTarget());
        return model;
    }

    public void recordSuppressedField(String fieldName) {
        this.suppressedFields.add(fieldName);
    }

    public String[] getSuppressedFields() {
        return StringUtils.toStringArray(this.suppressedFields);
    }

    protected String canonicalFieldName(String field) {
        return field;
    }

    public Class getFieldType(String field) {
        return null;
    }

    protected abstract Object getActualFieldValue(String var1);

    protected Object formatFieldValue(String field, Object value) {
        return value;
    }
}

