/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.orm.jpa.SpringPersistenceUnitInfo;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistenceUnitReader {
    private static final String MAPPING_FILE_NAME = "mapping-file";
    private static final String JAR_FILE_URL = "jar-file";
    private static final String MANAGED_CLASS_NAME = "class";
    private static final String PROPERTIES = "properties";
    private static final String PROVIDER = "provider";
    private static final String EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    private static final String NON_JTA_DATA_SOURCE = "non-jta-data-source";
    private static final String JTA_DATA_SOURCE = "jta-data-source";
    private static final String TRANSACTION_TYPE = "transaction-type";
    private static final String PERSISTENCE_UNIT = "persistence-unit";
    private static final String UNIT_NAME = "name";
    private static final String SCHEMA_NAME = "persistence_1_0.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private final DataSourceLookup dataSourceLookup;

    public PersistenceUnitReader(ResourceLoader resourceLoader, DataSourceLookup dataSourceLookup) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        Assert.notNull(dataSourceLookup, "DataSourceLookup must not be null");
        this.resourceLoader = resourceLoader;
        this.dataSourceLookup = dataSourceLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringPersistenceUnitInfo[] readPersistenceUnitInfos(String persistenceXmlLocation) {
        SpringPersistenceUnitInfo[] springPersistenceUnitInfoArray;
        SimpleSaxErrorHandler handler = new SimpleSaxErrorHandler(this.logger);
        ArrayList<SpringPersistenceUnitInfo> infos = new ArrayList<SpringPersistenceUnitInfo>();
        Resource resource = this.resourceLoader.getResource(persistenceXmlLocation);
        InputStream stream = resource.getInputStream();
        try {
            Document document = this.validateResource(handler, stream);
            this.parseDocument(document, infos);
            springPersistenceUnitInfoArray = infos.toArray(new SpringPersistenceUnitInfo[infos.size()]);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot parse persistence unit from " + resource, ex);
            }
            catch (SAXException ex) {
                throw new IllegalArgumentException("Invalid XML in persistence unit from " + resource, ex);
            }
            catch (ParserConfigurationException ex) {
                throw new IllegalArgumentException("Internal error parsing persistence unit from " + resource);
            }
        }
        stream.close();
        return springPersistenceUnitInfoArray;
    }

    protected List<SpringPersistenceUnitInfo> parseDocument(Document document, List<SpringPersistenceUnitInfo> infos) throws IOException {
        Element persistence = document.getDocumentElement();
        List units = DomUtils.getChildElementsByTagName(persistence, PERSISTENCE_UNIT);
        for (Element unit : units) {
            infos.add(this.parsePersistenceUnitInfo(unit));
        }
        return infos;
    }

    protected Element getChildElementByName(Element rootElement, String childName) {
        NodeList nl = rootElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, childName)) continue;
            return (Element)node;
        }
        return null;
    }

    protected String getChildElementValueByName(Element rootElement, String childName) {
        Element child = this.getChildElementByName(rootElement, childName);
        String value = null;
        if (child != null) {
            value = DomUtils.getTextValue(child).trim();
        }
        return StringUtils.hasText(value) ? value : null;
    }

    protected SpringPersistenceUnitInfo parsePersistenceUnitInfo(Element persistenceUnit) throws IOException {
        Element excludeUnlistedClasses;
        String provider;
        String nonJtaDataSource;
        String jtaDataSource;
        SpringPersistenceUnitInfo unitInfo = new SpringPersistenceUnitInfo();
        unitInfo.setPersistenceUnitName(persistenceUnit.getAttribute(UNIT_NAME).trim());
        String txType = persistenceUnit.getAttribute(TRANSACTION_TYPE).trim();
        if (StringUtils.hasText(txType)) {
            unitInfo.setTransactionType(PersistenceUnitTransactionType.valueOf((String)txType));
        }
        if ((jtaDataSource = this.getChildElementValueByName(persistenceUnit, JTA_DATA_SOURCE)) != null) {
            unitInfo.setJtaDataSource(this.dataSourceLookup.getDataSource(jtaDataSource));
        }
        if ((nonJtaDataSource = this.getChildElementValueByName(persistenceUnit, NON_JTA_DATA_SOURCE)) != null) {
            unitInfo.setNonJtaDataSource(this.dataSourceLookup.getDataSource(nonJtaDataSource));
        }
        if ((provider = this.getChildElementValueByName(persistenceUnit, PROVIDER)) != null) {
            unitInfo.setPersistenceProviderClassName(provider);
        }
        if ((excludeUnlistedClasses = this.getChildElementByName(persistenceUnit, EXCLUDE_UNLISTED_CLASSES)) != null) {
            unitInfo.setExcludeUnlistedClasses(true);
        }
        this.parseMappingFiles(persistenceUnit, unitInfo);
        this.parseJarFiles(persistenceUnit, unitInfo);
        this.parseClass(persistenceUnit, unitInfo);
        this.parseProperty(persistenceUnit, unitInfo);
        return unitInfo;
    }

    protected void parseProperty(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        Element propRoot = this.getChildElementByName(persistenceUnit, PROPERTIES);
        if (propRoot == null) {
            return;
        }
        List properties = DomUtils.getChildElementsByTagName(propRoot, "property");
        for (Element property : properties) {
            String name = property.getAttribute(UNIT_NAME);
            String value = property.getAttribute("value");
            unitInfo.addProperty(name, value);
        }
    }

    protected void parseClass(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        List classes = DomUtils.getChildElementsByTagName(persistenceUnit, MANAGED_CLASS_NAME);
        for (Element element : classes) {
            String value = DomUtils.getTextValue(element).trim();
            if (!StringUtils.hasText(value)) continue;
            unitInfo.addManagedClassName(value);
        }
    }

    protected void parseJarFiles(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) throws IOException {
        List jars = DomUtils.getChildElementsByTagName(persistenceUnit, JAR_FILE_URL);
        for (Element element : jars) {
            String value = DomUtils.getTextValue(element).trim();
            if (!StringUtils.hasText(value)) continue;
            Resource resource = this.resourceLoader.getResource(value);
            unitInfo.addJarFileUrl(resource.getURL());
        }
    }

    protected void parseMappingFiles(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        List files = DomUtils.getChildElementsByTagName(persistenceUnit, MAPPING_FILE_NAME);
        for (Element element : files) {
            String value = DomUtils.getTextValue(element).trim();
            if (!StringUtils.hasText(value)) continue;
            unitInfo.addMappingFileName(value);
        }
    }

    protected Document validateResource(ErrorHandler handler, InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        ClassPathResource schemaLocation = new ClassPathResource(SCHEMA_NAME);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        dbf.setNamespaceAware(true);
        dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        dbf.setAttribute(JAXP_SCHEMA_SOURCE, schemaLocation.getURL().toString());
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setErrorHandler(handler);
        return parser.parse(stream);
    }
}

