/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class BeanUtils {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$Class;

    public static Object instantiateClass(Class clazz) throws BeansException {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        try {
            return BeanUtils.instantiateClass(clazz.getDeclaredConstructor(null), null);
        }
        catch (NoSuchMethodException ex) {
            throw new BeanInstantiationException(clazz, "No default constructor found", ex);
        }
    }

    public static Object instantiateClass(Constructor ctor, Object[] args) throws BeansException {
        Assert.notNull(ctor, "Constructor must not be null");
        try {
            if (!Modifier.isPublic(ctor.getModifiers()) || !Modifier.isPublic(ctor.getDeclaringClass().getModifiers())) {
                ctor.setAccessible(true);
            }
            return ctor.newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is it an abstract class?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Has the class definition changed? Is the constructor accessible?", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Illegal arguments for constructor", ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", ex.getTargetException());
        }
    }

    public static Method findMethod(Class clazz, String methodName, Class[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return BeanUtils.findDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Method findDeclaredMethod(Class clazz, String methodName, Class[] paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            if (clazz.getSuperclass() != null) {
                return BeanUtils.findDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes);
            }
            return null;
        }
    }

    public static Method findMethodWithMinimalParameters(Class clazz, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.doFindMethodWithMinimalParameters(clazz.getDeclaredMethods(), methodName);
        if (targetMethod == null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz, methodName);
        }
        return targetMethod;
    }

    public static Method findDeclaredMethodWithMinimalParameters(Class clazz, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.doFindMethodWithMinimalParameters(clazz.getDeclaredMethods(), methodName);
        if (targetMethod == null && clazz.getSuperclass() != null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz.getSuperclass(), methodName);
        }
        return targetMethod;
    }

    private static Method doFindMethodWithMinimalParameters(Method[] methods, String methodName) throws IllegalArgumentException {
        Method targetMethod = null;
        int numMethodsFoundWithCurrentMinimumArgs = 0;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            int numParams = methods[i].getParameterTypes().length;
            if (targetMethod == null || numParams < targetMethod.getParameterTypes().length) {
                targetMethod = methods[i];
                numMethodsFoundWithCurrentMinimumArgs = 1;
                continue;
            }
            if (targetMethod.getParameterTypes().length != numParams) continue;
            ++numMethodsFoundWithCurrentMinimumArgs;
        }
        if (numMethodsFoundWithCurrentMinimumArgs > 1) {
            throw new IllegalArgumentException("Cannot resolve method '" + methodName + "' to a unique method. Attempted to resolve to overloaded method with " + "the least number of parameters, but there were " + numMethodsFoundWithCurrentMinimumArgs + " candidates.");
        }
        return targetMethod;
    }

    public static Method resolveSignature(String signature, Class clazz) {
        Assert.hasText(signature, "Signature must not be null or zero-length");
        Assert.notNull(clazz, "Class must not be null");
        int firstParen = signature.indexOf("(");
        int lastParen = signature.indexOf(")");
        if (firstParen > -1 && lastParen == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + signature + "': expected closing ')' for args list");
        }
        if (lastParen > -1 && firstParen == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + signature + "': expected opening '(' for args list");
        }
        if (firstParen == -1 && lastParen == -1) {
            return BeanUtils.findMethodWithMinimalParameters(clazz, signature);
        }
        String methodName = signature.substring(0, firstParen);
        String[] parameterTypeNames = StringUtils.commaDelimitedListToStringArray(signature.substring(firstParen + 1, lastParen));
        Class[] parameterTypes = new Class[parameterTypeNames.length];
        for (int i = 0; i < parameterTypeNames.length; ++i) {
            String parameterTypeName = parameterTypeNames[i].trim();
            try {
                parameterTypes[i] = ClassUtils.forName(parameterTypeName, clazz.getClassLoader());
                continue;
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Invalid method signature: unable to locate type [" + parameterTypeName + "] for argument " + i);
            }
        }
        return BeanUtils.findMethod(clazz, methodName, parameterTypes);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz);
        return cr.getBeanInfo().getPropertyDescriptors();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class clazz, String propertyName) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz);
        return cr.getPropertyDescriptor(propertyName);
    }

    public static PropertyDescriptor findPropertyForMethod(Method method) throws BeansException {
        Assert.notNull(method, "Method must not be null");
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(method.getDeclaringClass());
        for (int i = 0; i < pds.length; ++i) {
            if (!method.equals(pds[i].getReadMethod()) && !method.equals(pds[i].getWriteMethod())) continue;
            return pds[i];
        }
        return null;
    }

    public static Class findPropertyType(String propertyName, Class[] beanClasses) {
        if (beanClasses != null) {
            for (int i = 0; i < beanClasses.length; ++i) {
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(beanClasses[i], propertyName);
                if (pd == null) continue;
                return pd.getPropertyType();
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = BeanUtils.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public static String canonicalPropertyName(String propertyName) {
        if (propertyName == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(propertyName);
        int searchIndex = 0;
        while (searchIndex != -1) {
            int keyEnd;
            int keyStart = buf.toString().indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = buf.toString().indexOf("]", keyStart + "[".length())) == -1) continue;
            String key = buf.substring(keyStart + "[".length(), keyEnd);
            if (key.startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                buf.delete(keyStart + 1, keyStart + 2);
                buf.delete(keyEnd - 2, keyEnd - 1);
                keyEnd -= 2;
            }
            searchIndex = keyEnd + "]".length();
        }
        return buf.toString();
    }

    public static boolean isSimpleProperty(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveArray(clazz) || ClassUtils.isPrimitiveWrapper(clazz) || ClassUtils.isPrimitiveWrapperArray(clazz) || clazz.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtils.class$("java.lang.String")) : class$java$lang$String) || clazz.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtils.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || clazz.equals(class$java$lang$Class == null ? (class$java$lang$Class = BeanUtils.class$("java.lang.Class")) : class$java$lang$Class) || clazz.equals(array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = BeanUtils.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class);
    }

    public static boolean isAssignable(Class targetType, Class valueType) {
        return ClassUtils.isAssignable(targetType, valueType);
    }

    public static boolean isAssignable(Class type, Object value) {
        return ClassUtils.isAssignableValue(type, value);
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        BeanUtils.copyProperties(source, target, null, null);
    }

    public static void copyProperties(Object source, Object target, Class editable) throws BeansException {
        BeanUtils.copyProperties(source, target, editable, null);
    }

    public static void copyProperties(Object source, Object target, String[] ignoreProperties) throws BeansException {
        BeanUtils.copyProperties(source, target, null, ignoreProperties);
    }

    private static void copyProperties(Object source, Object target, Class editable, String[] ignoreProperties) throws BeansException {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(target, "Target must not be null");
        Class actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (int i = 0; i < targetPds.length; ++i) {
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = targetPds[i];
            if (targetPd.getWriteMethod() == null || ignoreProperties != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
                continue;
            }
            catch (Exception ex) {
                throw new FatalBeanException("Could not copy properties from source to target", ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

