/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public class CheckboxTag
extends AbstractHtmlInputElementTag {
    private Object value;

    public void setValue(Object value) {
        Assert.notNull(value, "'value' cannot be null.");
        this.value = value;
    }

    protected Object getValue() {
        return this.value;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", "checkbox");
        Object boundValue = this.getBoundValue();
        if (boundValue instanceof Boolean) {
            this.renderFromBoolean((Boolean)boundValue, tagWriter);
        } else {
            Object resolvedValue;
            Object value = this.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Attribute 'value' is required when binding to non-boolean values");
            }
            Object object = resolvedValue = value instanceof String ? this.evaluate("value", (String)value) : value;
            if (boundValue != null && boundValue.getClass().isArray()) {
                this.renderFromCollection(resolvedValue, CollectionUtils.arrayToList(boundValue), tagWriter);
            } else if (boundValue instanceof Collection) {
                this.renderFromCollection(resolvedValue, (Collection)boundValue, tagWriter);
            } else {
                this.renderSingleValue(resolvedValue, tagWriter);
            }
        }
        tagWriter.endTag();
        tagWriter.startTag("input");
        tagWriter.writeAttribute("type", "hidden");
        tagWriter.writeAttribute("value", "1");
        tagWriter.writeAttribute("name", "_" + this.getPath());
        tagWriter.endTag();
        return 6;
    }

    private void renderSingleValue(Object resolvedValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", ObjectUtils.getDisplayString(resolvedValue));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue)) {
            tagWriter.writeAttribute("checked", "true");
        }
    }

    private void renderFromCollection(Object resolvedValue, Collection boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", ObjectUtils.getDisplayString(resolvedValue));
        if (boundValue.contains(resolvedValue)) {
            tagWriter.writeAttribute("checked", "true");
        }
    }

    private void renderFromBoolean(Boolean boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", "true");
        if (boundValue.booleanValue()) {
            tagWriter.writeAttribute("checked", "true");
        }
    }

    protected String autogenerateId() throws JspException {
        return TagIdGenerator.nextId(this.getName(), this.pageContext);
    }
}

